#include <bits/stdc++.h>
using namespace std;

#define p3l pair<long long, pair<long long, long long>>
#define pll pair<long long, long long>
#define len(a) ((int)(a).size())
#define all(a) (a).begin(), (a).end()

constexpr int N = 2e5 + 5;

long long n, s, h;
long long k[N], g[N];
long long k_idx[N], g_idx[N];
pll interval[4 * N];
vector<p3l> axis;

long long flip(long long x, long long s) {
    return s - (x - s);
}

pll put_into(pll p, long long x) {
    return {min(p.first, x), max(p.second, x)};
}

void clear() {
    axis.clear();
}

void solve() {
    bool flipping = false;

    cin >> n >> s >> h;

    if (h < s) flipping = true;
    if (flipping) h = flip(h, s);

    for (int i = 0; i < n; i++) {
        cin >> k[i] >> g[i];
        if (flipping) {
            k[i] = flip(k[i], s);
            g[i] = flip(g[i], s);
        }
        axis.push_back({k[i], {i, 1}});
        axis.push_back({g[i], {i, 0}});
    }
    axis.push_back({s, {-1, -1}});
    axis.push_back({h, {-2, -2}});

    sort(all(axis));

    long long start_idx = 0, hatch_idx = 0;

    for (int i = 0; i < len(axis); i++) {
        if (axis[i].second.first == -1) {
            start_idx = i;
        } else if (axis[i].second.first == -2) {
            hatch_idx = i;
        } else {
            if (axis[i].second.second == 1) {
                k_idx[axis[i].second.first] = i;
            } else {
                g_idx[axis[i].second.first] = i;
            }
        }
    }

    for (int i = 0; i < n; i++) {
        if (g_idx[i] > start_idx && hatch_idx > g_idx[i] && k_idx[i] > g_idx[i]) {
            cout << "-1\n";
            clear();
            return;
        }
    }

    interval[start_idx] = {start_idx, start_idx};

    for (int i = start_idx + 1; i <= hatch_idx; i++) {
        if (axis[i].second.second == 0) {
            interval[i] = put_into(interval[i - 1], k_idx[axis[i].second.first]);
        } else {
            interval[i] = interval[i - 1];
        }
        if (interval[i].second > i) {
            cout << "-1\n";
            clear();
            return;
        }
    }

    for (int i = start_idx - 1; i >= 0; i--) {
        if (axis[i].second.second == 0) {
            interval[i] = put_into(interval[i + 1], k_idx[axis[i].second.first]);
        } else {
            interval[i] = interval[i + 1];
        }
        if (interval[i].first < i && interval[hatch_idx].first <= i) {
            cout << "-1\n";
            clear();
            return;
        }
    }

    long long ans = axis[hatch_idx].first - axis[start_idx].first;
    long long cur_idx = hatch_idx, prev_idx = -1;

    while (cur_idx != start_idx) {
        if (cur_idx > start_idx) {
            if (interval[cur_idx].second > cur_idx) {
                cout << "-1\n";
                clear();
                return;
            }
            if (interval[cur_idx].first == prev_idx) {
                cout << "-1\n";
                clear();
                return;
            }
            prev_idx = cur_idx;
            cur_idx = interval[cur_idx].first;
            ans += 2 * abs(axis[cur_idx].first - axis[start_idx].first);
        } else {
            if (interval[cur_idx].first < cur_idx) {
                cout << "-1\n";
                clear();
                return;
            }
            if (interval[cur_idx].second == prev_idx) {
                cout << "-1\n";
                clear();
                return;
            }
            prev_idx = cur_idx;
            cur_idx = interval[cur_idx].second;
            ans += 2 * abs(axis[cur_idx].first - axis[start_idx].first);
        }
    }

    cout << ans << "\n";
    clear();
}

int main() {
#ifdef DEBUG_MODE
    freopen("input.txt", "r", stdin);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int _ = 1;
    cin >> _ ;
    while ( _ --) {
        solve();
    }
    return 0;
}