#include <string>
#include <vector>
#include <iostream>
using namespace std;

string bigMul(const string &a, const string &b) {
    vector<int> A(a.size()), B(b.size());

    for (int i = 0; i < (int)a.size(); i++) A[i] = a[a.size()-1-i] - '0';
    for (int i = 0; i < (int)b.size(); i++) B[i] = b[b.size()-1-i] - '0';

    vector<int> C(A.size() + B.size() + 5, 0);

    for (int i = 0; i < (int)A.size(); i++)
        for (int j = 0; j < (int)B.size(); j++)
            C[i + j] += A[i] * B[j];


    int carry = 0;
    for (int i = 0; i < (int)C.size(); i++) {
        int x = C[i] + carry;
        C[i] = x % 10;
        carry = x / 10;
    }

    while (C.size() > 1 && C.back() == 0) C.pop_back();

    string r;
    for (int i = C.size()-1;i>=0;i--) r+=char('0' + C[i]);
    return r;
}

bool valid(const string &s, const string &c, int k) {
    int n = s.size();
    if (k <= 0 || k >= n) return false;

    string b = s.substr(n-k,k);
    string a = s.substr(0,n-k);

    if (b[0] == '0' || a[0] == '0') return false;

    string prod = bigMul(b,c);
    return prod == a;
}

int main() {

    string s, c;
    cin >> s >> c;

    int n = s.size(), lc = c.size();
    vector<int> candidates;

    if ((n - lc) % 2 == 0) candidates.push_back((n - lc) / 2);
    if ((n - lc + 1) % 2 == 0) candidates.push_back((n - lc + 1) / 2);

    for (int k : candidates) {
        if (valid(s, c, k)) {
            string b = s.substr(n-k, k);
            string a = s.substr(0,n-k);
            cout << a << " " << b << "\n";
            return 0;
        }
    }

    return 0;
}