#include <iostream>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <algorithm>
#include <numeric>
#include <limits>
#include <deque>
#include <stack>
#include <queue>
#include <utility>
#include <set>

using ull = unsigned long long;
using ll = long long;

struct Node {
    std::string name1;
    std::string name2;
};

void print_map(std::unordered_map<std::string, std::set<int>> name1Map) {
    for (auto i : name1Map) {
        std::cout << i.first << ": ";
        for (auto j : i.second) {
            std::cout << j << " ";
        }
        std::cout << std::endl;
    }
}
bool solve() {
    int n;
    std::cin >> n;
    std::vector<Node> nodes;
    std::unordered_map<std::string, std::set<int>> name1Map;
    std::unordered_map<std::string, std::set<int>> name2Map;
    for (int i = 0; i < n; i++) {
        std::string name1;
        std::string name2;
        std::cin >> name1 >> name2;
        nodes.push_back(Node{name1, name2});
        name1Map[name1].insert(i);
        name2Map[name2].insert(i);
    }

    for (int i = 0; i < n-1; i++) {
        auto [name1, name2] = nodes[i];
        name1Map[name1].erase(i);
        name2Map[name2].erase(i);
        bool go_by_first = true;
        bool go_by_second = true;
        auto& children1 = name1Map[name1];
        if (children1.empty()) {
            go_by_first = false;
        }
        auto& children2 = name2Map[name2];
        if (children2.empty()) {
            go_by_second = false;
        }
        if (!go_by_first && !go_by_second) {
            continue;
        }
        bool is_ok = false;
        if (go_by_first) {
            if (children1.count(i+1) == 1) {
                is_ok = true;
            }
        }
        if (go_by_second) {
            if (children2.count(i+1) == 1) {
                is_ok = true;
            }
        }
        if (!is_ok) {
            return false;
        }
    }
    return true;
}

int main() {
    int t;
    std::cin >> t;
    for (int i = 0; i < t; i++) {
        if (solve()) {
            std::cout << "Yes\n";
        } else {
            std::cout << "No\n";
        }
    }
}
