#include <bits/stdc++.h>
using namespace std;

#define dbg(x) cerr << #x << ' '; print(x); cerr << endl;
void print(int x) {cerr << x;}
void print(long long x) {cerr << x;}
void print(double x) {cerr << x;}
void print(char x) {cerr << x;}
void print(string x) {cerr << x;}

template <class T> void print(vector <T> x) {cerr << "[ "; for (T i : x) {print(i); cerr << ' ';} cerr << "]";}
template <class T> void print(set <T> x) {cerr << "[ "; for (T i : x) {print(i); cerr << ' ';} cerr << "]";}
template <class T> void print(multiset <T> x) {cerr << "[ "; for (T i : x) {print(i); cerr << ' ';} cerr << "]";}
template <class T, class V> void print(pair <T, V> x) {cerr << "{"; print(x.first); cerr << ", "; print(x.second); cerr << "}";}
template <class T, class V> void print(map <T, V> x) {cerr << "[ "; for (auto i : x) {print(i); cerr << ' ';} cerr << "]";}

#define ll long long
#define pb push_back
#define ppb pop_back

const ll inf = 1e18;
const int N = 2e5 + 10;

ll a[N], n, q;

struct segtree {
    struct Node {
        ll mn, mx;
        ll len;
    };

    vector<Node> stree;
    int size = 1;

    void init() {
        while (size <= n) size <<= 1;
        stree.assign(4*size, {inf, 0, 0});
        build(0, 0, size);
    }

    Node merge(Node A, Node B) {
        if (A.mx < B.mn) {
            return {A.mn, B.mx, A.len + B.len};
        }
        if (A.len > B.len) return A;
        return B;
    }

    void build(int x, int lx, int rx) {
        if (rx - lx == 1) {
            if (lx <= n) {
                stree[x] = {a[lx], a[lx], 1};
            }
            return;
        }
        int m = (lx + rx)/2;
        build(2*x+1, lx, m);
        build(2*x+2, m, rx);
        stree[x] = merge(stree[2*x+1], stree[2*x+2]);
    }

    Node qry(int l, int r, int x, int lx, int rx) {
        if (lx >= r || rx <= l) return {inf, 0, 0};
        if (lx >= l && rx <= r) return stree[x];
        int m = (lx + rx)/2;
        return merge(qry(l, r, 2*x+1, lx, m), qry(l, r, 2*x+2, m, rx));
    }

    ll qry(int l, int r) {
        return qry(l, r, 0, 0, size).len;
    }
} st;

void solve(int tc) {
    cin >> n >> q;
    for (int i = 1; i <= n; i++) {
        cin >> a[i];
    }
    st.init();
    while (q--) {
        int l, r;
        cin >> l >> r;
        cout << st.qry(l, r + 1) << endl;
    }
}

int main() {
    int tc = 1;
    cin >> tc;
    int cnt = 1;
    while (tc--) {
        solve(cnt++);
    }
    return 0;
}