#include <bits/stdc++.h>

using namespace std;

int n;

constexpr int dx = 13800, dy = 130400;
const vector<int> d = {-1, 0, 1};
map<pair<int, int>, bool> mp;

bool query(const int x, const int y) {
    if (mp.find({x, y}) != mp.end()) return mp[{x, y}];
    cout << "? " << x + dx << " " << y + dy << endl;
    fflush(stdout);
    string s;
    cin >> s;
    return mp[{x, y}] = (s == "W");
}

void answer(const vector<pair<int, int> >& w) {
    for (const auto &[x, y] : w) {
        cout << " " << x + dx << " " << y + dy;
    }
    cout << endl;
    fflush(stdout);
}

pair<int, int> mn(const vector<pair<int, int> >& w) {
    pair<int, int> p = w[0];
    for (const auto& p2: w) {
        if (p2 < p) p = p2;
    }
    return p;
}

void solve() {
    mp.clear();
    vector<pair<int, int> > w, b;
    set<pair<int,int> > s;
    if (query(0, 0)) {
        w.emplace_back(0, 0);
    } else {
        b.emplace_back(0, 0);
    }
    s.emplace(0, 0);
    while (w.size() < n && b.size() < n) {
        set<pair<int,int> > sw, sb;
        for (const auto &[x, y]: w) {
            for (const int d1: d) {
                for (const int d2: d) {
                    pair<int, int> point = {x + d1, y + d2};
                    if (s.find(point) == s.end()) {
                        sw.insert(point);
                    }
                }
            }
        }
        for (const auto &[x, y]: b) {
            for (const int d1: d) {
                for (const int d2: d) {
                    pair<int, int> point = {x + d1, y + d2};
                    if (s.find(point) == s.end()) {
                        sb.insert(point);
                    }
                }
            }
        }
        pair<int, int> point = {0, 0};
        for (const auto &p: sw) {
            if (sb.find(p) != sb.end()) {
                point = p;
                break;
            }
        }
        if (point.first == 0 && point.second == 0) {
            // not found
            bool clean_w = false;
            if (sw.empty()) clean_w = true;
            else if (!b.empty() && mn(b).first < mn(w).first) clean_w = true;
            if (clean_w) {
                w.clear();
                point = *sb.begin();
            } else {
                b.clear();
                point = *sw.begin();
            }
        }
        if (query(point.first, point.second)) {
            w.emplace_back(point.first, point.second);
        } else {
            b.emplace_back(point.first, point.second);
        }
        s.emplace(point.first, point.second);
    }
    if (w.size() == n) {
        cout << "! W";
        answer(w);
    } else {
        cout << "! B";
        answer(b);
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int t = 1;
    cin >> t;
    cin >> n;
    for (int i=0;i<t;++i) {
        solve();
    }
    return 0;
}
