#include <bits/stdc++.h>

using namespace std;

int n;

constexpr int dx = 13800, dy = 130400;
const vector<int> d = {-1, 0, 1};
map<pair<int, int>, bool> mp;
int Q = 30000;

bool query(const int x, const int y) {
    if (mp.find({x, y}) != mp.end()) return mp[{x, y}];
    Q--;
    if (Q == 0) {
        exit(1);
    }
    cout << "? " << x + dx << " " << y + dy << endl;
    fflush(stdout);
    string s;
    cin >> s;
    return mp[{x, y}] = (s == "W");
}

void answer(const set<pair<int, int> >& w) {
    for (const auto &[x, y] : w) {
        cout << " " << x + dx << " " << y + dy;
    }
    cout << endl;
    fflush(stdout);
}

void solve() {
    mp.clear();
    set<pair<int, int> > w, b;
    set<pair<int,int> > s;
    set<pair<int,int> > sw, sb;
    auto addw = [&](int x, int y) {
        w.emplace(x, y);
        for (const int d1: d) {
            for (const int d2: d) {
                const pair<int, int> point = {x + d1, y + d2};
                if (s.find(point) == s.end()) {
                    sw.insert(point);
                }
            }
        }
    };
    auto addb = [&](int x, int y) {
        b.emplace(x, y);
        for (const int d1: d) {
            for (const int d2: d) {
                const pair<int, int> point = {x + d1, y + d2};
                if (s.find(point) == s.end()) {
                    sb.insert(point);
                }
            }
        }
    };
    auto adds = [&](int x, int y) {
        s.emplace(x, y);
        sw.erase({x, y});
        sb.erase({x, y});
    };
    if (query(0, 0)) {
        addw(0, 0);
    } else {
        addb(0, 0);
    }
    adds(0, 0);
    while (w.size() < n && b.size() < n) {
        pair<int, int> point = {0, 0};
        for (const auto &p: sw) {
            if (sb.find(p) != sb.end()) {
                point = p;
                break;
            }
        }
        if (point.first == 0 && point.second == 0) {
            // not found
            bool clean_w = false;
            if (sw.empty()) clean_w = true;
            else if (!b.empty() && b.begin()->first < w.begin()->first) clean_w = true;
            if (clean_w) {
                w.clear();
                sw.clear();
                point = *sb.begin();
            } else {
                b.clear();
                sb.clear();
                point = *sw.begin();
            }
        }
        if (point.first == 0 && point.second == 0) {
            exit(1);
        }

        if (query(point.first, point.second)) {
            addw(point.first, point.second);
        } else {
            addb(point.first, point.second);
        }
        adds(point.first, point.second);
    }
    if (w.size() == n) {
        cout << "! W";
        answer(w);
    } else {
        cout << "! B";
        answer(b);
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int t = 1;
    cin >> t;
    cin >> n;
    for (int i=0;i<t;++i) {
        solve();
    }
    return 0;
}
