#include <bits/stdc++.h>
using namespace std;

int maxX = -1;
int maxY = -1;
bool found = false;
char resultColor = 'W';
vector<pair<int, int>> resultPath;

void dfs(int x, int y, set<pair<int, int>>& visited, char color, int n, vector<pair<int, int>>& path) {
    if (found) return;
    visited.insert({x, y});
    path.push_back({x, y});
    if (path.size() == n) {
        found = true;
        resultColor = color;
        for (int i = 0; i < path.size(); i++) {
            resultPath.push_back(path[i]);
        }
        return;
    }
    maxX = max(maxX, x);
    maxY = max(maxY, y);
    for (int i = -1; i <= 1; i++) {
        for (int j = -1; j <= 1; j++) {
            if (!(i == 0 && j == 0)) {
                int newX = x + i;
                int newY = y + j;
                if (visited.find({newX, newY}) != visited.end()) continue;
                cout << "? " << newX << " " << newY << endl;
                char newColor;
                cin >> newColor;
                if (newColor == color) {
                    dfs(newX, newY, visited, color, n, path);
                }
            }
        }
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t, n;
    cin >> t >> n;

    while (t--) {
        maxX = -1;
        maxY = -1;
        found = false;
        set<pair<int, int>> visited;
        resultPath.clear();
        int x = maxX + 1;
        int y = maxY + 1;
        cout << "? " << x << " " << y << endl;
        char color;
        cin >> color;
        if (color == 'B') {
            color = 'W';
        } else {
            color = 'B';
        }
        while (!found) {
            if (color == 'B') {
                color = 'W';
            } else {
                color = 'B';
            }
            vector<pair<int, int>> path;
            dfs(maxX + 1, maxY + 1, visited, color, n, path);
        }

        cout << "! " << resultColor << " ";
        for (int i = 0; i < resultPath.size(); i++) {
            cout << resultPath[i].first << " " << resultPath[i].second << " ";
        }
        cout << '\n';
    }
    return 0;
}
