#include <iostream>
#include <vector>
#include <string>
#include <boost/multiprecision/cpp_int.hpp>

using namespace std;
using boost::multiprecision::cpp_int;

cpp_int toBigInt(const string& s) {
    cpp_int value = 0;
    for (char ch : s) {
        value *= 10;
        value += ch - '0';
    }
    return value;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    string s, c_str;
    if (!(cin >> s >> c_str)) {
        return 0;
    }

    int len_s = static_cast<int>(s.size());
    int len_c = static_cast<int>(c_str.size());

    vector<int> candidates;
    int diff = len_s - len_c;
    if (diff >= 0 && diff % 2 == 0) {
        int m = diff / 2;
        if (m > 0 && m < len_s) {
            candidates.push_back(m);
        }
    }
    if (diff + 1 >= 0 && (diff + 1) % 2 == 0) {
        int m = (diff + 1) / 2;
        if (m > 0 && m < len_s) {
            candidates.push_back(m);
        }
    }

    cpp_int c = toBigInt(c_str);

    for (int m : candidates) {
        int split = len_s - m;
        string a_str = s.substr(0, split);
        string b_str = s.substr(split);

        if ((a_str.size() > 1 && a_str[0] == '0') || (b_str.size() > 1 && b_str[0] == '0')) {
            continue;
        }

        cpp_int a = toBigInt(a_str);
        cpp_int b = toBigInt(b_str);

        if (a == b * c) {
            cout << a_str << " " << b_str << "\n";
            return 0;
        }
    }

    return 0;
}
