#include <iostream>
#include <vector>
#include <string>
#include <algorithm>

using namespace std;

const int BASE = 1000000000;
const int CHUNK = 9;

void trim(vector<int>& v) {
    while (v.size() > 1 && v.back() == 0) {
        v.pop_back();
    }
}

vector<int> parseBigInt(const string& s) {
    vector<int> digits;
    for (int i = static_cast<int>(s.size()); i > 0; i -= CHUNK) {
        int start = max(0, i - CHUNK);
        int len = i - start;
        digits.push_back(stoi(s.substr(start, len)));
    }
    trim(digits);
    return digits;
}

vector<int> multiply(const vector<int>& a, const vector<int>& b) {
    if (a.empty() || b.empty()) {
        return {0};
    }
    vector<__int128_t> tmp(a.size() + b.size());
    for (size_t i = 0; i < a.size(); ++i) {
        for (size_t j = 0; j < b.size(); ++j) {
            tmp[i + j] += static_cast<__int128_t>(a[i]) * b[j];
        }
    }

    vector<int> result(tmp.size());
    long long carry = 0;
    for (size_t k = 0; k < tmp.size(); ++k) {
        __int128_t cur = tmp[k] + carry;
        result[k] = static_cast<int>(cur % BASE);
        carry = static_cast<long long>(cur / BASE);
    }
    while (carry > 0) {
        result.push_back(static_cast<int>(carry % BASE));
        carry /= BASE;
    }
    trim(result);
    return result;
}

bool equalBigInt(vector<int> lhs, vector<int> rhs) {
    trim(lhs);
    trim(rhs);
    return lhs == rhs;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    string s, c_str;
    if (!(cin >> s >> c_str)) {
        return 0;
    }

    int len_s = static_cast<int>(s.size());
    int len_c = static_cast<int>(c_str.size());

    vector<int> candidates;
    auto addCandidate = [&](int m) {
        if (m > 0 && m < len_s) {
            candidates.push_back(m);
        }
    };

    int diff = len_s - len_c;
    if (diff >= 0 && diff % 2 == 0) {
        addCandidate(diff / 2);
    }
    if ((diff + 1) >= 0 && (diff + 1) % 2 == 0) {
        addCandidate((diff + 1) / 2);
    }
    sort(candidates.begin(), candidates.end());
    candidates.erase(unique(candidates.begin(), candidates.end()), candidates.end());

    vector<int> c_big = parseBigInt(c_str);

    for (int m : candidates) {
        int split = len_s - m;
        if (split <= 0 || split >= len_s) {
            continue;
        }
        string a_str = s.substr(0, split);
        string b_str = s.substr(split);
        if ((a_str.size() > 1 && a_str[0] == '0') || (b_str.size() > 1 && b_str[0] == '0')) {
            continue;
        }

        vector<int> a_big = parseBigInt(a_str);
        vector<int> b_big = parseBigInt(b_str);

        vector<int> prod = multiply(b_big, c_big);
        if (equalBigInt(prod, a_big)) {
            cout << a_str << " " << b_str << "\n";
            return 0;
        }
    }

    return 0;
}
