from functools import lru_cache

n = int(input())
ops = [input().split() for _ in range(n)]

sync_ops = []
async_ops = []

for op, val, mode in ops:
    val = int(val)
    if mode == 'sync':
        sync_ops.append((op, val))
    else:
        async_ops.append((op, val))

m = len(async_ops)
results = set()

@lru_cache(None)
def dfs(i_sync, async_mask, A):
    if i_sync == len(sync_ops) and async_mask == (1 << m) - 1:
        results.add(A)
        return

    for j in range(m):
        if not (async_mask & (1 << j)):
            op, val = async_ops[j]
            if op == '+':
                dfs(i_sync, async_mask | (1 << j), A + val)
            else:  # op == '='
                dfs(i_sync, async_mask | (1 << j), val)


    if i_sync < len(sync_ops):
        op, val = sync_ops[i_sync]
        if op == '+':
            dfs(i_sync + 1, async_mask, A + val)
        else:  # op == '='
            dfs(i_sync + 1, async_mask, val)

dfs(0, 0, 0)

print(len(results))

             
             