import sys

data = sys.stdin.read().strip().split()
it = iter(data)
t = int(next(it))
out_lines = []
for _ in range(t):
    n = int(next(it))
    names = []
    for _ in range(n):
        a = next(it)
        b = next(it)
        names.append((a, b))

    if n == 1:
        out_lines.append("Yes")
        continue

    from collections import Counter
    cnt_first = Counter()
    cnt_second = Counter()
    for i in range(1, n):
        f, s = names[i]
        cnt_first[f] += 1
        cnt_second[s] += 1

    ok = True
    for i in range(1, n):
        prev_f, prev_s = names[i-1]
        has_similar = (cnt_first.get(prev_f, 0) > 0) or (cnt_second.get(prev_s, 0) > 0)
        cur_f, cur_s = names[i]
        cur_similar = (cur_f == prev_f) or (cur_s == prev_s)
        if has_similar and not cur_similar:
            ok = False
            break
        cnt_first[cur_f] -= 1
        if cnt_first[cur_f] == 0:
            del cnt_first[cur_f]
        cnt_second[cur_s] -= 1
        if cnt_second[cur_s] == 0:
            del cnt_second[cur_s]

    out_lines.append("Yes" if ok else "No")

sys.stdout.write("\n".join(out_lines))
