from random import seed, randint, sample

MAX_N = 1000
MAX_D = 1000

test_no = 0

def test(boxes):
    assert 1 <= len(boxes) <= MAX_N
    for box in boxes:
        assert len(box) == 3
        for d in box:
            assert 1 <= d <= MAX_D

    global test_no
    test_no += 1
    with open(f'{test_no:02}', 'w', encoding='utf-8') as f:
        print(len(boxes), file=f)
        for box in boxes:
            print(*box, file=f)

seed('Northwestern Russia Regional Contest 2025, 3475324058')

def test_generator(n, gen):
    test([gen() for _ in range(n)])

def test_random_box(n, box, max_d):
    test_generator(n, lambda: sample([randint(box[0], max_d), randint(box[1], max_d), randint(box[2], max_d)], 3))

def test_random(n, max_d):
    test_random_box(n, [randint(1, max_d), randint(1, max_d), randint(1, max_d)], max_d)

def almost(n):
    return randint(n - n // 10, n)
    
test([[6, 5, 6], [2, 10, 10], [3, 8, 4]])
test([[2, 3, 4]])
test([[4, 5, 6], [4, 5, 6], [4, 5, 6]])
test_generator(MAX_N, lambda: [1, 1, 1])

test_random(10, 20)
test_random_box(10, [1, 1, MAX_D], MAX_D)
test_random_box(10, [1, MAX_D, MAX_D], MAX_D)

test_random(100, 20)
test_random(MAX_N, 20)

test_random(10, MAX_D)
test_random(100, MAX_D)
test_random(MAX_N, MAX_D)

test_random_box(MAX_N, [almost(MAX_D // 30), almost(MAX_D // 5), almost(MAX_D)], MAX_D)
test_random_box(MAX_N, [almost(MAX_D // 30), almost(MAX_D // 30), almost(MAX_D)], MAX_D)

test_random_box(MAX_N, [almost(MAX_D), almost(MAX_D), almost(MAX_D)], MAX_D)
test_random_box(MAX_N, [MAX_D, MAX_D, MAX_D], MAX_D)
