#include "testlib.h"
#include <stdio.h>
#include <string>
#include <set>
#include <vector>

std::set<unsigned> visited;
std::vector<unsigned> tests;

void add_test(unsigned t) {
    auto elem = visited.find(t);
    if (elem == visited.end()) {
        visited.insert(t);
        tests.push_back(t);
    }
}

int main(int argc, char** argv) {
    setName("Generate test for conversion (NERC)");
    registerGen(argc, argv, 1);

    int n = atoi(argv[1]);

    for (int t : {6, 7, 13, 14, 20, 21, 27, 28, 29, 30}) {
        add_test((1 << t) - 2);
        add_test((1 << t) - 1);
        if (t != 7 && t != 14) {
          add_test((1 << t));
        }
        add_test((1 << t) + 1);
    }

    add_test((1 << 31) - 2);
    add_test((1 << 31) - 5);

    for (int t = 0; t <= 30; t++) {
      add_test(rnd.next(1 << t, int((1 << (t + 1)) - 1)));
    }

    for (int b : {1, 5, 16, 27, 29}) {
      int x = 1 << 30;
      std::set<int> s;
      while (int(s.size()) < b) {
        s.insert(rnd.next(0, 29));
      }
      for (int i : s) {
        x |= 1 << i;
      }
      add_test(x);
    }

    for (int t = 0; t < 17; t++) {
        add_test(rnd.next(__TESTLIB_LONGLONG_MAX) & 0x7fffffff);
    }

    if (n == 0) {
        printf("total: %lu\n", tests.size());
        for (int i = 0; i < tests.size(); i++) {
            printf("%u=%x\n", tests[i], tests[i]);
        }
        printf("\n");
    }
    else {
        std::cout << tests[n - 1] << "\n";
    }
    return 0;
}
