// #pragma comment(linker, "/stack:200000000")
// #pragma GCC optimize("Ofast,no-stack-protector")
// #pragma GCC target("sse,sse2,sse3,ssse3,sse4,popcnt,abm,mmx,avx,avx2,tune=native")
// #pragma GCC optimize("unroll-loops")

#include <stdio.h>
#include <bits/stdc++.h>

#ifdef PERVEEVM_LOCAL
    #define debug(x...) std::cerr << "[DEBUG]\t" << __LINE__ << ":\t" << (#x) << " = "; print_debug(x)
#else
    #define debug(x...) 238
#endif

#define fastIO std::ios_base::sync_with_stdio(false); std::cin.tie(0); std::cout.tie(nullptr)
#define NAME "File"

using ll = long long;
using ld = long double;

#ifdef PERVEEVM_LOCAL
    std::mt19937 rnd(238);
#else
    std::mt19937 rnd(std::chrono::high_resolution_clock::now().time_since_epoch().count());
#endif

template<typename T1, typename T2>
std::ostream& operator<<(std::ostream& out, const std::pair<T1, T2>& p) {
    out << "(" << p.first << ", " << p.second << ")";
    return out;
}

template<size_t index, typename T>
std::ostream& print_tuple(std::ostream& out, const T& t) {
    if constexpr (index == std::tuple_size<T>::value) {
        out << ")";
        return out;
    } else {
        if (index > 0) {
            out << ", ";
        } else {
            out << "(";
        }
        out << std::get<index>(t);
        return print_tuple<index + 1, T>(out, t);
    }
}

template<typename ...T>
std::ostream& operator<<(std::ostream& out, const std::tuple<T...>& t) {
    return print_tuple<0, std::tuple<T...>>(out, t);
}

template<typename Container, typename = decltype(std::begin(std::declval<Container>()))>
typename std::enable_if<!std::is_same<Container, std::string>::value, std::ostream&>::type
operator<<(std::ostream& out, const Container& container) {
    out << "{";
    for (auto it = container.begin(); it != container.end(); ++it) {
        if (it != container.begin()) {
            out << ", ";
        }
        out << *it;
    }
    out << "}";
    return out;
}

void print_debug() {
    std::cerr << std::endl;
}

template<typename T, typename... V>
void print_debug(const T& value, const V&... others) {
    std::cerr << value;
    if (sizeof...(others) != 0) {
        std::cerr << ", ";
        print_debug(others...);
    } else {
        std::cerr << std::endl;
    }
}

template<typename T>
bool smin(T& a, const T& b) {
    if (b < a) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
bool smax(T& a, const T& b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

const double PI = atan2(0.0, -1.0);
const int INF = 0x3f3f3f3f;
const ll LINF = (ll)2e18;

void run() {
    int a, b, c;
    scanf("%d%d%d", &a, &b, &c);

    if (a > b + c || b > a + c || c > a + b) {
        printf("No\n");
        return;
    }

    int x = (a + b - c) / 2;
    int y = (a + c - b) / 2;
    int z = (b + c - a) / 2;

    std::string s1, s2, s3;
    for (int i = 0; i < x; ++i) {
        s1.push_back('a');
        s2.push_back('b');
        s3.push_back('b');
    }
    for (int i = 0; i < y; ++i) {
        s1.push_back('b');
        s2.push_back('a');
        s3.push_back('b');
    }
    for (int i = 0; i < z; ++i) {
        s1.push_back('b');
        s2.push_back('b');
        s3.push_back('a');
    }

    if ((a + b + c) % 2 == 1) {
        s1.push_back('x');
        s2.push_back('y');
        s3.push_back('z');
    }
    if (s1.empty()) {
        s1.push_back('d');
        s2.push_back('d');
        s3.push_back('d');
    }

    printf("Yes\n%s\n%s\n%s\n", s1.c_str(), s2.c_str(), s3.c_str());
}

int main(void) {
    // freopen(NAME".in", "r", stdin);
    // freopen(NAME".out", "w", stdout);

    #ifdef PERVEEVM_LOCAL
        auto start = std::chrono::high_resolution_clock::now();
    #endif

    run();

    #ifdef PERVEEVM_LOCAL
        auto end = std::chrono::high_resolution_clock::now();
        std::cerr << "Execution time: "
                  << std::chrono::duration_cast<std::chrono::milliseconds>(end - start).count()
                  << " ms" << std::endl;
    #endif

    return 0;
}
