#include "testlib.h"
#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <algorithm>
#include <cmath>
#include <vector>
#include <set>
#include <map>
#include <unordered_set>
#include <unordered_map>
#include <queue>
#include <ctime>
#include <cassert>
#include <complex>
#include <string>
#include <cstring>
#include <chrono>
#include <random>
#include <bitset>
#include <fstream>
#include <array>
#include <functional>
#include <stack>
#include <memory>
 
#define all(v) v.begin(), v.end()
#define app push_back
 
#ifdef LOCAL
#define debug(...) [](auto...a) { ((cout << a << ' '), ...) << endl; }(#__VA_ARGS__, ":", __VA_ARGS__)
#define debugv(v) do { cout << #v << ": "; for (auto x : v) cout << x << ' '; cout << endl; } while(0)
#else
#define debug(...)
#define debugv(v)
#endif
 
using namespace std;
 
const int MAX_N = 100000, MAX_M = 200000, MAX_T = 10000;
 
tuple<int, int, vector <vector <int> > > readInput(InStream &in) {
    int n = in.readInt(2, MAX_N, "n");
    int m = in.readInt(n - 1, MAX_M, "m");
    vector <vector <int> > g(n);
    for (int i = 0; i < m; ++i) {
        int u = in.readInt(1, n, "u_i");
        int v = in.readInt(1, n, "v_i");
        u--; v--;
        g[u].app(v);
        g[v].app(u);
    }
    return {n, m, g};
}
 
pair <bool, vector<int> > readAnswer(InStream &ouf, int n) {
    int c0 = ouf.readInt(-1, n, "c_0");
    if (c0 == 0) {
        ouf.quitf(_wa, "-1 or 1..%d expected in answer, but %d found", n, c0);
    }
    if (c0 == -1) return make_pair(false, vector <int> ());
    vector<int> c(n);
    c[0] = c0;
    for (int i = 1; i < n; ++i) {
        c[i] = ouf.readInt(1, n, "c_i");
    }
    return {true, c};
}
 
int check(int n, vector <vector <int> > g, bool type, vector <int> c) {
    if (type == false) {
        return 0;
    }

    for (int u = 0; u < n; ++u) {
        int deg = 0;
        for (int v : g[u]) {
            if (c[u] == c[v]) {
                deg++;
            }
        }
        if (deg % 2 == 0) {
            return 1;
        }
    }

    return 0;
}
 
int32_t main(int argc, char* argv[]) {
    registerTestlibCmd(argc, argv);
    int testCases = inf.readInt(1, MAX_T, "t");
    for (int t = 0; t < testCases; ++t) {
        setTestCase(t + 1);
        auto [n, m, g] = readInput(inf);
        auto [jt, ja] = readAnswer(ans, n);
        auto [pt, pa] = readAnswer(ouf, n);
        int x = check(n, g, jt, ja);
        if (x == 1) quitf(_fail, "jury made an incorrect coloring");
        assert(x == 0);
        int y = check(n, g, pt, pa);
        if (y == 1) quitf(_wa, "participant made an incorrect coloring");
        assert(y == 0);
        if ((!jt) && pt) quitf(_fail, "jury hasn't found the answer, but participant has");
        if (jt && (!pt)) quitf(_wa, "jury has found the answer, but participant hasn't");
    }
    quitf(_ok, "%d test cases(s)", testCases);
}
