#include "testlib.h"
#include <bits/stdc++.h>
 
#define all(v) v.begin(), v.end()
#define app push_back
 
#ifdef LOCAL
#define debug(...) [](auto...a) { ((cout << a << ' '), ...) << endl; }(#__VA_ARGS__, ":", __VA_ARGS__)
#define debugv(v) do { cout << #v << ": "; for (auto x : v) cout << x << ' '; cout << endl; } while(0)
#else
#define debug(...)
#define debugv(v)
#endif
 
using namespace std;
 
const int MAX_T = 10'000;
const int MAX_N = 100'000;
const int MAX_M = 200'000;
 
int32_t main(int argc, char* argv[]) {
    registerValidation(argc, argv);
    int testCaseCount = inf.readInt(1, MAX_T, "t");
    inf.readEoln();
    int sum_n = 0, sum_m = 0;
    for (int testCase = 1; testCase <= testCaseCount; testCase++) {
        setTestCase(testCase);
        int n = inf.readInt(2, MAX_N, "n");
        inf.readSpace();
        int m = inf.readInt(n - 1, MAX_M, "m");
        inf.readEoln();
        sum_n += n;
        sum_m += m;
        vector <vector <int> > g(n);
        set <pair <int, int> > e;
        for (int i = 0; i < m; ++i) {
            int u = inf.readInt(1, n, "u_i");
            inf.readSpace();
            int v = inf.readInt(1, n, "v_i");
            u--; v--;
            if (v < u) {
                swap(u, v);
            }
            g[u].app(v); g[v].app(u);
            ensuref(u != v, "there must be no loops");
            ensuref(e.find({u, v}) == e.end(), "there must be no multiple edges");
            e.insert({u,v});
            inf.readEoln();
        }

        vector <int> used(n);
        function <void(int)> dfs = [&] (int u) {
            used[u] = 1;
            for (int v : g[u]) {
                if (!used[v]) {
                    dfs(v);
                }
            }
        };
        dfs(0);

        for (int u = 0; u < n; ++u) {
            ensuref(used[u], "the graph must be connected");
        }
        
    }
    ensuref(sum_n <= MAX_N, "sum of all n must not be greater than %d", MAX_N);
    ensuref(sum_m <= MAX_M, "sum of all m must not be greater than %d", MAX_M);
    inf.readEof();
    return 0;
}
