#include <functional>
#include <iostream>
#include <map>
#include <vector>
#include <set>

using namespace std;

int main() {
    ios::sync_with_stdio(false);

    int n, k;
    cin >> n >> k;

    vector<int> hs(n);
    for (int& h : hs) {
        cin >> h;
    }

    using TState = tuple<int, int, vector<int>>; // (score, size, {cnt(2 ^ (i + 1))})

    set<TState> visitedStates;
    map<int, vector<int>> results;
    set<int> needResults{hs.begin(), hs.end()};

    const function<void(TState&)> go = [&](TState& state) {
        if (visitedStates.count(state)) {
            return;
        }
        visitedStates.insert(state);

        auto& [score, size, counts] = state;

        if (needResults.count(score) && !results.count(score)) {
            vector<int> numbers;
            for (int i = 0; i <= k; i++) {
                for (int j = 0; j < counts[i]; ++j) {
                    numbers.push_back(2 << i);
                }
            }
            results[score] = numbers;
        }

        for (int i = 0; i < k; i++) {
            if (counts[i] >= 2) {
                counts[i] -= 2;
                counts[i + 1]++;
                score += (4 << i);
                size--;

                go(state);

                size++;
                score -= (4 << i);
                counts[i + 1]--;
                counts[i] += 2;
            }
        }

        if (size < k) {
            for (int i = 0; i < 2; i++) {
                counts[i]++;
                size++;

                go(state);

                size--;
                counts[i]--;
            }
        }
    };

    TState initialState = {0, 0, vector<int>(k + 1, 0)};
    go(initialState);

    for (const auto h : hs) {
        if (!results.count(h)) {
            cout << "-1\n";
            continue;
        }

        const auto& numbers = results[h];
        cout << numbers.size();
        for (int x : numbers) {
            cout << " " << x;
        }
        cout << "\n";
    }
}
