
def solve(h, k):
    if h % 4 != 0:
        return None

    minMax = {4: (0, 4)}
    for i in range(3, k + 2):
        x = 2 ** i
        a, b = minMax[x // 2]
        minMax[x] = (a * 2 + x, b * 2 + x)

    result = []
    while h > 0 and minMax:
        x = max(x for x, (a, _) in minMax.items() if a <= h)
        result.append(x)

        maxX = max(minMax.keys())
        a, b = minMax[x]
        if x == maxX:
            b -= 4
            del minMax[maxX]

        h -= min(b, h)

    if h != 0:
        return None
    return result


def main():
    n, k = map(int, input().split())
    for _ in range(n):
        h = int(input())
        result = solve(h, k)
        if result is None:
            print(-1)
        else:
            print(len(result), *result)


if __name__ == '__main__':
    main()
