import java.io.*;
import java.util.*;
import java.util.Map.*;

public class WA {
	FastScanner in;
	PrintWriter out;
	boolean systemIO = true;

	int n;
	int INF = 40000;

	int[] dx = { -1, -1, -1, 0, 0, 1, 1, 1 };
	int[] dy = { -1, 0, 1, -1, 1, -1, 0, 1 };
	
	public boolean request(int[] q) {
		System.out.println("? " + q[0] + " " + q[1]);
		String s = in.next();
		if (s.equals("0")) {
			System.exit(0);
		}
		return s.equals("W");
	}
	
	public int toInt(int[] q) {
		return q[0] * INF + q[1];
	}
	
	public void solve() {
		Random random = new Random(566);
		HashMap<Integer, Boolean> map = new HashMap<>();
		int[] q = { INF / 4, INF / 4 };
		ArrayList<Integer> ans = new ArrayList<>();
		boolean c0 = request(q);
		map.put(toInt(q), c0);
		int sz = 1;
		ans.add(toInt(q));
		Queue<Integer> nei = new ArrayDeque<>();
		for (int k = 0; k < 8; ++k) {
			q[0] = INF / 4 + dx[k];
			q[1] = INF / 4 + dy[k];
			nei.add(toInt(q));
		}
		while (sz < n) {
			boolean find = false;
			boolean c;
			int h = -1;
			while (!nei.isEmpty()) {
				int key = nei.poll();
				if (map.containsKey(key)) {
					continue;
				}
				q[0] = key / INF;
				q[1] = key % INF;
				c = request(q);
				if (c == c0) {
					++sz;
					ans.add(toInt(q));
				}
				find = true;
				map.put(key, c);
				for (int k = 0; k < 8; ++k) {
					int[] q1 = {q[0] + dx[k], q[1] + dy[k]};
					h = toInt(q1);
					if (!map.containsKey(h)) {
						nei.add(h);
					}
				}
				break;
			}
			if (find) {
				continue;
			}
			while (true) {
				assert(nei.size() == 0);
				q[0] = INF / 4 + random.nextInt(INF / 4);
				q[1] = INF / 4 + random.nextInt(INF / 4);
				h = toInt(q);
				if (map.containsKey(h)) {
					continue;
				}
				c = request(q);
				map.put(h, c);
				if (c == c0) {
					sz = 1;
					ans.clear();
					ans.add(h);
					for (int k = 0; k < 8; ++k) {
						int[] q_ = {q[0] + dx[k], q[1] + dy[k]};
						nei.add(toInt(q_));
					}
					break;
				}
			}
		}
		if (c0) {
			System.out.print("! W");
		} else {
			System.out.print("! B");
		}
		for (int x : ans) {
			System.out.print(" " + x / INF + " " + x % INF);
		}
		System.out.println();
	}
	
	public void run() {
		try {
			if (systemIO) {
				in = new FastScanner(System.in);
				out = new PrintWriter(System.out);
			} else {
				in = new FastScanner(new File("input.txt"));
				out = new PrintWriter(new File("output.txt"));
			}
			
			int t = in.nextInt();
			n = in.nextInt();
			
			for (int i = 0; i < t; ++i) {
				solve();
			}

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	class FastScanner {
		BufferedReader br;
		StringTokenizer st;

		FastScanner(File f) {
			try {
				br = new BufferedReader(new FileReader(f));
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}

		FastScanner(InputStream f) {
			br = new BufferedReader(new InputStreamReader(f));
		}

		String nextLine() {
			try {
				return br.readLine();
			} catch (IOException e) {
				return null;
			}
		}

		String next() {
			while (st == null || !st.hasMoreTokens()) {
				try {
					st = new StringTokenizer(br.readLine());
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			return st.nextToken();
		}

		int nextInt() {
			String s = next();
			int res = 0;
			if (s.charAt(0) == '-') {
				for (int i = 1; i < s.length(); i++) {
					res = 10 * res + s.charAt(i) - '0';
				}
				return -res;
			}
			for (int i = 0; i < s.length(); i++) {
				res = 10 * res + s.charAt(i) - '0';
			}
			return res;
		}

		long nextLong() {
			return Long.parseLong(next());
		}

		double nextDouble() {
			return Double.parseDouble(next());
		}

	}

	public static void main(String[] arg) {
		new WA().run();
	}
}
