#include "testlib.h"
#include <iostream>

using namespace std;

int const MAX_N = 2000;
int const MAX_T = 2000;

struct TestCase {
  int n, k, d;
};

int main(int argc, char *argv[]) {
  registerGen(argc, argv, 1);
  int min_n = opt<int>("min-n", 1);
  int max_n = opt<int>("max-n", MAX_N);
  int min_k = opt<int>("min-k", 1);
  int max_k = opt<int>("max-k", MAX_N);
  int min_d = opt<int>("min-d", 1);
  int max_d = opt<int>("max-d", MAX_N);
  
  vector<TestCase> test_cases;
  for (int n = min_n; n <= max_n; n++) {
    for (int k = min(min_k, n); k <= max_k && k <= n; k++) {
      for (int d = min_d; d <= max_d; d++) {
        test_cases.push_back({n, k, d});
      }
    }
  }
  cout << test_cases.size() << endl;
  for (int i = 0; i < test_cases.size(); i++) {
    setTestCase(i);
    const auto &test_case = test_cases[i];
    cout << test_case.n << " " << test_case.k << " " << test_case.d << endl;
  }
  return 0;
}
