#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>

using namespace std;

const int mod1 = 1e9 + 9;
const int mod2 = 1e9 + 7;
const int mod3 = 1e9 + 97;

int rest(const string& s, int mod)
{
    long long r = 0;
    for (int i = 0; i < s.size(); i++)
    {
        r *= 10;
        r += s[i] - '0';
        r %= mod;
    }
    // cout << s <<  " " << mod << " " << r << endl;
    return r;
}

bool check(const string& t1, const string& t2, const string& c, int mod)
{
    return rest(t1, mod) == (1ll * rest(t2, mod) * rest(c, mod) % mod);
}


int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    string s, c;
    cin >> s >> c;
    int middle = (s.size() + c.size()) / 2;
    for (int i = max(middle - 5, 1); i < min(middle + 6, (int)s.size()); i++)
    {
        string t1 = s.substr(0, i);
        string t2 = s.substr(i);
        if (t2[0] == '0') continue;
        // cout << t1 << " " << t2 << " " << check(t1, t2, c, mod1) << endl;
        if (check(t1, t2, c, mod1) && check(t1, t2, c, mod2) && check(t1, t2, c, mod3))
        {
            cout << t1 <<  " " << t2;
            return 0;
        }
    }

    return 0;
}