#include <bits/stdc++.h>

#define sz(v) (int) v.size()
#define all(v) v.begin(), v.end()

using namespace std;

#ifdef LOCAL
    #define cerr cout
#else
    #define cerr if(0) cerr
#endif // LOCAL

typedef long long ll;
typedef long double ld;
typedef pair<int, int> pii;

const int MAXN = 2e3 + 10, MAXX = 510, MAXB = MAXX * MAXN;

bitset<MAXB> async_adds[MAXN];

void print_bitset(const bitset<MAXB>& b) {
    for (int i = 0; i < 40; i++) {
        if (b[i]) {
            cerr << i << ' ';
        }
    }
    cerr << endl;
}

int32_t main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif // LOCAL
    ios::sync_with_stdio(0);
    cin.tie(0);

    int n;
    cin >> n;
    int current = 0;

    vector<tuple<char, int, string> > inp(n);
    char c;
    int x;
    string type;

    bitset<MAXB> adds;
    adds[0] = 1;

    for (int i = 0; i < n; i++) {
        cin >> c >> x >> type;
        inp[i] = make_tuple(c, x, type);
        if (type == "async" && c == '+') {
            adds |= (adds << x);
        }
        async_adds[i] = adds;
    }

    bitset<MAXB> res = 0;
    bitset<MAXB> all_sufs = adds;
    int suf_add = 0;

    bool was_sync_set = false;
    bool was_async_set = false;
    for (int i = n - 1; i >= 0; i--) {
        auto [c, x, type] = inp[i];
        if (type == "sync") {
            if (c == '=') {
                if (!was_sync_set && !was_async_set) {
                    res |= (async_adds[i] << (x + suf_add));
                }
                was_sync_set = true;
                continue;
            } else {
                if (was_sync_set || was_async_set) {
                    continue;
                }
                suf_add += x;
                all_sufs |= (async_adds[i] << suf_add);
            }
        } else {
            if (c == '+') {
                if (!was_sync_set) {
                    suf_add += x;
                }
                continue;
            } else {
                was_async_set = true;
                //cerr << "async = " << x << ";all sufs:\n";
                //print_bitset(all_sufs);
                res |= (all_sufs << x);
            }
        }
    }
    if (!was_sync_set && !was_async_set) {
        res[suf_add] = 1;
    }
    cout << res.count() << '\n';

    return 0;
}

/*
async adds:
0 3 6 9 10 12 13 15 16 18 19 22 25 28
see new syn add; curr added_suf:
4 7 10 13 14 16 17 19 20 22 23 26 29 32
all sufs:
0 3 4 6 7 9 10 12 13 14 15 16 17 18 19 20 22 23 25 26 28 29 32
see new syn add; curr added_suf:
5 8 11 14 15 17 18 20 21 23 24 27 30 33
all sufs:
0 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 32 33
add async set 7; curr sufs:
0 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 32 33
res:
7 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 39
31
*/

