#include <bits/stdc++.h>

#define sz(v) (int) v.size()
#define all(v) v.begin(), v.end()

using namespace std;

typedef long long ll;
typedef long double ld;
typedef pair<int, int> pii;

const int H = 4e6;
const int K = 16;
const int inf = 1e9;

int dp[H];
int ls[H];

void precalc() {
    dp[0] = 0;
    fill(dp + 1, dp + H, inf);
    for (int h = 1; h < H; h++) {
        for (int x = 3; x - 1 <= K; x++) {
            int score = (1 << x) * (x - 2);
            if (score > h) break;

            int value = max(1 + dp[h - score], x - 1);
            if (value < dp[h]) {
                dp[h] = value;
                ls[h] = x;
            }
        }
    }
}

int32_t main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif // LOCAL
    ios::sync_with_stdio(0);
    cin.tie(0);

    precalc();

    int n, k;
    cin >> n >> k;
    while (n--) {
        int h;
        cin >> h;
        if (h % 4 != 0) {
            cout << "-1\n";
            continue;
        }
        if (h == 4) {
            cout << "1 4\n";
            continue;
        }
        if (h % 8 != 0) {
            h -= 4;
        }
        if (h >= H || dp[h] > k) {
            cout << "-1\n";
            continue;
        }
        vector<int> ans;
        while (h > 0) {
            int x = ls[h];
            ans.push_back(1 << x);
            int score = (1 << x) * (x - 2);
            h -= score;
        }
        cout << sz(ans) << " ";
        for (int x : ans) cout << x << " ";
        cout << "\n";
    }

    return 0;
}

