#include <iostream>
#include <algorithm>
#include <vector>
#include <cassert>
#include <unordered_set>
#include <bitset>

using namespace std;


using ll = long long;
#define forn(i, n) for(ll i = 0; i < (n); ++i)


void solve() {
    int n;
    cin >> n;

    struct Q {
        char t;
        ll x;
        char op;
    };

    vector<Q> q(n);
    forn(i, n) {
        char t;
        ll x;
        string op;
        cin >> t >> x >> op;

        q[i] = {t, x, op[0]};
    }

    // stand before i
    vector<ll> suf(n + 1, 0);
    vector<ll> has(n + 1, false);

    for (int i = n - 1; i >= 0; --i) {
        suf[i] = suf[i + 1];
        has[i] = has[i + 1];

        if (q[i].t == '+') {
            suf[i] += q[i].x;
        } else {
            has[i] = true;
        }
    }


    bitset<2000 * 500 + 10> b1, b2, res;
    b1[0] = true;

    forn(i, n) {
        if (q[i].t == '=') {
            if (q[i].op == 'a') {
                b2 |= (b1 << q[i].x);
            } else {
                if (has[i + 1]) {
                    continue;
                }
                res |= (b1 << (q[i].x + suf[i + 1]));
            }
        } else {
            if (q[i].op == 'a') {
                b1 |= (b1 << q[i].x);
                b2 |= (b2 << q[i].x);
            } else {
                // skip
            }
        }

        if (!has[i + 1]) {
            // go async
            res |= (b2 << suf[i + 1]);
        }
    }

    cout << res.count() << "\n";
}

int main() {
    int t = 1;
//    cin >> t;
    while (t--) {
        solve();
    }
}


