#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <cassert>
#include <unordered_set>

using namespace std;


using ll = long long;
#define forn(i, n) for(ll i = 0; i < (n); ++i)


void solve() {
    int n ;
    cin >> n;

    set<pair<ll, ll>> w;
    set<pair<ll, ll>> b;
    set<pair<ll, ll>> wn;
    set<pair<ll, ll>> bn;
    map<pair<ll, ll>, char> color;

    auto neighs = [](pair<ll, ll> p) {
        auto [x, y] = p;
        vector<pair<ll, ll>> ns{
                {x - 1, y - 1},
                {x - 1, y + 1},
                {x + 1, y - 1},
                {x + 1, y + 1},

                {x - 1, y},
                {x + 1, y},
                {x, y - 1},
                {x, y + 1},
        };
        return ns;
    };

    auto ask = [&](ll x, ll y) {
        cout << "? " << x << " " << y << endl;
        char c;
        cin >> c;

        pair<ll, ll> p{x, y};
        color[p] = c;

        wn.erase(p);
        bn.erase(p);

        if (c == 'W') {
            w.insert(p);
        } else {
            b.insert(p);
        }

        for (auto to : neighs(p)) {
            if (color.contains(to)) {
                continue;
            }
            (c == 'W' ? wn : bn).insert(to);
        }
        return c;
    };

    int x = 0, y = 0;
    auto fc = ask(x, y);
    while(true) {
        ++x;
        auto sc = ask(x, y);

        if (w.size() >= n) {
            cout << "! W ";
            for (auto [x, y] : w) {
                cout << x << " " << y << " ";
            }
            cout << endl;
            return;
        } else if (b.size() >= n) {
            cout << "! B ";
            for (auto [x, y] : b) {
                cout << x << " " << y << " ";
            }
            cout << endl;
            return;
        }

        if (sc != fc) {
            break;
        }
    }



    while (true) {
        set<pair<ll, ll>> com;
        for (auto p : wn) {
            if (bn.contains(p)) {
                com.insert(p);
                break;
            }
        }

        if (com.empty()) {
            assert(false);
        }

        auto top = *com.begin();
        ask(top.first, top.second);

        if (w.size() >= n) {
            cout << "! W ";
            for (auto [x, y] : w) {
                cout << x << " " << y << " ";
            }
            cout << endl;
            return;
        } else if (b.size() >= n) {
            cout << "! B ";
            for (auto [x, y] : b) {
                cout << x << " " << y << " ";
            }
            cout << endl;
            return;
        }

    }
}

int main() {
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
}


