#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <map>
#include <array>
#include <set>

using namespace std;
using ll = long long;
#define x first
#define y second
using point = pair<ll, ll>;

bool is_white(point p) {
	cout << "? " << p.x << ' ' << p.y << endl;
	char c; cin >> c;
	return c == 'W';
}

vector<point> near(point p) {
	vector<point> ans;
	ans.push_back({ p.x, p.y + 1 });
	ans.push_back({ p.x + 1, p.y });
	ans.push_back({ p.x, p.y - 1 });
	ans.push_back({ p.x - 1, p.y});
	ans.push_back({ p.x + 1, p.y + 1 });
	ans.push_back({ p.x - 1, p.y + 1 });
	ans.push_back({ p.x + 1, p.y - 1 });
	ans.push_back({ p.x - 1, p.y - 1 });
	return ans;
}

set<point> white_s, black_s, neighbours_s;

bool ready_b(ll n) {
	if (black_s.size() == n) {
		cout << "! B ";
		for (point p : black_s) {
			cout << p.x << ' ' << p.y << ' ';
		}
		cout << endl;
		return true;
	}
	return false;
}

bool ready_w(ll n) {
	if (white_s.size() == n) {
		cout << "! W ";
		for (point p : white_s) {
			cout << p.x << ' ' << p.y << ' ';
		}
		cout << endl;
		return true;
	}
	return false;
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	cout.tie(0);
	ll t, n; cin >> t >> n;
	point cur = { 0, 0 };
	while (t--) {
		white_s.clear();
		black_s.clear();
		neighbours_s.clear();
		bool finished = false;

		if (is_white(cur)) {
			white_s.insert(cur);
			cur.x += 1;
			while (is_white(cur)) {
				white_s.insert(cur);
				if (finished = ready_w(n)) {
					break;
				}
				cur.x += 1;
			}
			if (finished) {
				continue;
			}
			black_s.insert(cur);
			neighbours_s.insert({ cur.x, cur.y + 1 });
			neighbours_s.insert({ cur.x - 1, cur.y + 1 });
			neighbours_s.insert({ cur.x, cur.y - 1 });
			neighbours_s.insert({ cur.x - 1, cur.y - 1 });
		}
		else {
			black_s.insert(cur);
			cur.x += 1;
			while (!is_white(cur)) {
				black_s.insert(cur);
				if (finished = ready_b(n)) {
					break;
				}
				cur.x += 1;
			}
			if (finished) {
				continue;
			}
			white_s.insert(cur);
			neighbours_s.insert({ cur.x, cur.y + 1 });
			neighbours_s.insert({ cur.x - 1, cur.y + 1 });
			neighbours_s.insert({ cur.x, cur.y - 1 });
			neighbours_s.insert({ cur.x - 1, cur.y - 1 });
		}
		while (!finished && !neighbours_s.empty()) {
			cur = *neighbours_s.begin();
			neighbours_s.erase(cur);
			if (is_white(cur)) {
				white_s.insert(cur);
				if (finished = ready_w(n)) {
					break;
				}
				auto ngh = near(cur);
				for (point p : ngh) {
					if (!white_s.count(p) && !black_s.count(p) && !neighbours_s.count(p)) {
						auto p_ngh = near(p);
						for (point p1 : p_ngh) {
							if (black_s.count(p1)) {
								neighbours_s.insert(p);
								break;
							}
						}
					}
				}
			}
			else {
				black_s.insert(cur);
				if (finished = ready_b(n)) {
					break;
				}
				auto ngh = near(cur);
				for (point p : ngh) {
					if (!white_s.count(p) && !black_s.count(p) && !neighbours_s.count(p)) {
						auto p_ngh = near(p);
						for (point p1 : p_ngh) {
							if (white_s.count(p1)) {
								neighbours_s.insert(p);
								break;
							}
						}
					}
				}
			}
			if (neighbours_s.size() == 0) {
				point b_mx = { -1000000, -1000000 }, w_mx = { -1000000, -1000000 };
				for (auto p : black_s) {
					if (p.x > b_mx.x) {
						b_mx = p;
					}
					else if (p.x == b_mx.x && p.y > b_mx.y) {
						b_mx = p;
					}
				}
				for (auto p : white_s) {
					if (p.x > w_mx.x) {
						w_mx = p;
					}
					else if (p.x == w_mx.x && p.y > w_mx.y) {
						w_mx = p;
					}
				}
				if (b_mx.x < w_mx.x) {
					black_s.clear();
					cur = w_mx;
					cur.x += 1;
					while (is_white(cur)) {
						white_s.insert(cur);
						if (finished = ready_w(n)) {
							break;
						}
						cur.x += 1;
					}
					if (finished) {
						break;
					}

					black_s.insert(cur);
					auto ngh = near(cur);
					for (point p : ngh) {
						if (!white_s.count(p) && !black_s.count(p) && !neighbours_s.count(p)) {
							auto p_ngh = near(p);
							for (point p1 : p_ngh) {
								if (white_s.count(p1)) {
									neighbours_s.insert(p);
									break;
								}
							}
						}
					}
				}
				else {
					white_s.clear();
					cur = b_mx;
					cur.x += 1;
					while (!is_white(cur)) {
						black_s.insert(cur);
						if (finished = ready_b(n)) {
							break;
						}
						cur.x += 1;
					}
					if (finished) {
						continue;
					}

					white_s.insert(cur);
					auto ngh = near(cur);
					for (point p : ngh) {
						if (!white_s.count(p) && !black_s.count(p) && !neighbours_s.count(p)) {
							auto p_ngh = near(p);
							for (point p1 : p_ngh) {
								if (black_s.count(p1)) {
									neighbours_s.insert(p);
									break;
								}
							}
						}
					}
				}

			}
		}
		if (finished) {
			continue;
		}
	}
}
