#include <iostream>
#include <vector>
#include <algorithm>
#include <bitset>

typedef long long ll;
using namespace std;

struct ev {
    bool is_plus, is_sync;
    int v;
};

void solve() {
    const int N = 1'000'000;
    int n; cin >> n;
    vector <ev> a(n);
    int last_ravno = -1;
    for (int i = 0; i < n; i++) {
        char s; cin >> s;
        if (s == '+') {
            a[i].is_plus = true;
        } else {
            last_ravno = i;
        }
        int v; cin >> v;
        a[i].v = v;
        string str; cin >> str;
        if (str == "sync") {
            a[i].is_sync = true;
        }
    }
    if (last_ravno == -1) {
        cout << 1;
        return;
    }
    bitset<N> ans;
    if (a[last_ravno].is_sync) {
        for (int i = 0; i < last_ravno; i++) {
            if (!a[i].is_sync) {
                ans |= (ans << a[i].v);
                ans[a[i].v] = true;
            }
        }
        int sum = 0;
        for (int i = last_ravno; i < n; i++) {
            if (a[i].is_plus) {
                sum += a[i].v;
            }
        }
        ans <<= sum;
    }
    bitset<N> ans1;
    for (int i = 0; i < n; i++) {
        if (!a[i].is_sync && !a[i].is_plus) {
            ans1[a[i].v] = true;
        }
    }
    for (int i = 0; i < last_ravno; i++) {
        if (!a[i].is_sync && a[i].is_plus) {
            ans1 |= (ans1 << a[i].v);
        }
    }
    int sufsum = 0;
    for (int i = n - 1; i >= last_ravno; i--) {
        if (a[i].is_plus) {
            sufsum += a[i].v;
        }
    }
    for (int i = last_ravno + 1; i < n; i++) {
        ans |= (ans1 << sufsum);
        sufsum -= a[i].v;
        if (!a[i].is_sync) {
            ans1 |= (ans1 << a[i].v);
        }
    }
    ans |= ans1;
    cout << ans.count();
}


int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t = 1;
    //cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}