
#include <bits/stdc++.h>

using namespace std;

const int N = 1e6+10;

int solve(int n, vector<string> op, vector<int> a, vector<string> tp) {
    bitset<N> b; b[0] = 1;
    int last_eq = n - 1;

    vector<int> suf_sum(n + 1);
    for (int i = n - 1; i >= 0; --i) {
        suf_sum[i] = suf_sum[i + 1];
        if (op[i] == "+") {
            suf_sum[i] += a[i];
        }
    }
    while (last_eq >= 0 && op[last_eq] != "=")
        --last_eq;
    if (last_eq == -1) {
        return 1;
    }
    for (int i = n - 1; i > last_eq; --i) {
        if (op[i] == "=")
            continue;
        if (tp[i] == "sync") {
            b[suf_sum[i]] = true;
        } else {
            b |= b << a[i];
        }
    }
    for (int i = 0; i < last_eq; ++i) {
        if (op[i] == "+" && tp[i] == "async") {
            b |= b << a[i];
        }
    }
    bitset<N> pref; pref[0] = 1;
    bitset<N> ans;
    int pref_sum = 0;
    for (int i = 0; i < n; ++i) {
        if (op[i] == "=") {
            if (tp[i] == "sync") {
                if (i == last_eq) {
                    ans |= pref << (a[i] + suf_sum[i]);
                }
            } else {
                ans |= b << (a[i]);
            }
        } else {
            if (tp[i] == "async") {
                pref |= pref << a[i];
            } else {
                pref_sum += a[i];
            }
        }
    }
    return ans.count();
}

int stupid(int n, vector<string> op, vector<int> a, vector<string> tp) {
    vector<int> p(n);
    ranges::iota(p, 0);
    set<int> s;
    do {
        int x = 0;
        bool bad = false;
        vector<int> pos(n);
        for (int i = 0; i < n; ++i)
            pos[p[i]] = i;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (pos[i] < pos[j] && (tp[j] == "sync")) {
                    bad = true;
                }
            }
        }
        if (bad)
            continue;
        for (int i = 0; i < n; ++i) {
            if (op[p[i]] == "=")
                x = a[p[i]];
            else
                x += a[p[i]];
        }
        s.insert(x);
    } while (ranges::next_permutation(p).found);
    return s.size();
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n; cin >> n;
    vector<string> op(n);
    vector<int> a(n);
    vector<string> tp(n);
    for (int i = 0; i < n; ++i) {
        cin >> op[i] >> a[i] >> tp[i];
    }
    cout << solve(n, op, a, tp);
    return 0;

    for (int T = 0;; ++T) {
        cout << "TEST: " << T << endl;
        int n = rand() % 8 + 1;
        vector<string> op(n);
        vector<int> val(n);
        vector<string> tp(n);
        for (int i = 0; i < n; ++i) {
            if (rand() & 1) op[i] = "+";
            else op[i] = "=";
            val[i] = rand() % 10 + 1;
            if (rand() & 1) tp[i] = "async";
            else tp[i] = "sync";
        }
        auto s1 = solve(n, op, val, tp);
        auto s2 = stupid(n, op, val, tp);
        if (s1 != s2) {
            cout << n << "\n";
            for (int i = 0; i < n; ++i) {
                cout << op[i] << " " << val[i] << " " << tp[i] << "\n";
            }
            cout << s1 << "\n" << s2 << "\n";
            break;
        }
    }

    return 0;
}
/*
3
= 9 async
+ 7 async
= 10 sync
2
4
 */