// Gletcher Gang 2025 (Khramtsov, Sarycheva, Khramtsov, Laukhin, Khramtsov,
// Khramtsov, Khramtsov)

#include <algorithm>
#include <iostream>
#include <map>
#include <numeric>
#include <set>
#include <vector>

using namespace std;

map<int, multiset<int>> ans;
set<int> have;

int k;
multiset<int> s;
int N = 0;
int sc;

void dfs() {
  if (have.count(sc)) {
    ans[sc] = s;
  }

  if (sc >= N) {
    return;
  }
  for (int i = 0; i < 100 && (1 << i) <= N; i++) {
    if (s.count(1 << i) >= 2) {
      s.erase(s.find(1 << i));
      s.erase(s.find(1 << i));
      s.insert(2 << i);
      sc += 2 << i;
      dfs();
      sc -= 2 << i;
      s.erase(s.find(2 << i));
      s.insert(1 << i);
      s.insert(1 << i);
    }
  }

  if (s.size() < k) {
    s.insert(2);
    dfs();
    s.erase(s.find(2));
    s.insert(4);
    dfs();
    s.erase(s.find(4));
  }
}

int main() {
  cin.tie(nullptr)->sync_with_stdio(false);
  int n;
  cin >> n >> k;
  vector<int> h(n);
  for (int &x : h) {
    cin >> x;
    have.insert(x);
    N = max(N, x);
  }
  dfs();
  for (int i = 0; i < n; i++) {
    if (ans.count(h[i])) {
      cout << ans[h[i]].size() << " ";
      for (int x : ans[h[i]]) {
        cout << x << " ";
      }
      cout << "\n";
    } else {
      cout << "-1\n";
    }
  }
}