#include <bits/stdc++.h>
using namespace std;
using ll = long long;
using ull = unsigned long long;
using dl = long double;
#define for0(i,n) for(ll i = 0;i < n;++i)
#define for1(i,n) for(ll i = 1;i < n;++i)

void solve(){
   int n;
   cin >> n;
   string curf, curs;
   vector<pair<string, string> > order(n);
   for (auto&& [curf, curs] : order)
   {
       cin >> curf >> curs;
   }
   map<string, set<string> > first, second;
   for (int i = 1; i < order.size(); ++i) {
       auto [curf, curs] = order[i];
       first[curf].insert(curs);
       second[curs].insert(curf);
   }
   bool fl = 0;
   for (int i = 1; i < order.size(); ++i) {
       auto [prf, prs] = order[i - 1];
       auto [curf, curs] = order[i];
       first[curf].erase(curs);
       second[curs].erase(curf);
       if (curf != prf && prs != curs && (first[prf].size() || second[prs].size())) {
           fl = 1;
           break;
       }
   }
   cout << (fl ? "No\n" : "Yes\n");
}

int max(int x, int y, int z) {
    return max(x, max(y, z));
}

int min(int x, int y, int z) {
    return min(x, min(y, z));
}

struct cell {
    int x, y;
    int color;
    bool operator<(const cell& r) const {
        return tuple{x, y, color} < tuple{r.x, r.y, r.color};
    }
    bool operator==(const cell& r) const {
        return x == r.x && y == r.y && color == r.color;
    }
    auto adj() {
        vector<pair<int, int> > ret;
        for (int i = 0; i < 8; ++i) {
                int dx = (i == 1 || i == 5 ? 0 :
                          (i == 0 || i == 6 || i == 7 ? -1 :
                           1));
                int dy = (i == 7 || i == 3 ? 0 :
                          (i == 0 || i == 1 || i == 2 ? 1 :
                          -1));
                ret.push_back({x + dx, y + dy});
        }
        return ret;
    }
};


#include <random>
mt19937 rng(1213);
uniform_int_distribution distro(-1000000, 1000000);
struct dsu {
    map<pair<int, int>, cell> match;
    map<cell, int> size;
    map<cell, int> rank;
    map<cell, cell> anc;
    vector<cell> border;
    void unite_adj(cell x) {
        for (auto [dx, dy] : x.adj()) {
            bool was = match.count({dx, dy});
            if (get_cell(dx, dy).color == x.color) {
                unite(x, get_cell(dx, dy));
            } else if (!was) {
                border.push_back(get_cell(dx, dy));
            }
        }
    }
    cell get_cell(int x, int y) {
        if (match.count({x, y}))
            return match[{x, y}];
        cout << "? " << x << " " << y << endl;
        char color;
        cin >> color;
        match[{x, y}] = cell{x, y, color == 'B'};
        size[match[{x, y}]] = 1;
        return match[{x, y}];
    }
    void unite(cell a, cell b) {
        a = leader(a), b = leader(b);
        if (rank[a] > rank[b])
            swap(a, b);
        anc[a] = b;
        rank[b] = max(rank[b], rank[a] + 1);
    }
    void random_next_cell() {
        if (match.empty()) {
            int x = distro(rng), y = distro(rng);
            border.push_back(get_cell(x, y));
        } else {
            cell x = border.back();
            border.pop_back();
            unite_adj(x);
        }
    }
    cell leader(cell a) {
        return anc[a] == a ? a : anc[a] = leader(anc[a]);
    }
    vector<cell> component(cell lead) {
        vector<cell> ret;
        lead = leader(lead);
        for (auto [p, c] : match) {
            if (leader(c) == lead)
                ret.push_back(c);
        }
        return ret;
    }
    vector<cell> max_component() {
        set<cell> was;
        vector<cell> ret;
        for (auto [p, c] : match) {
            if (was.count(c)) {
                continue;
            } else {
                auto ncomp = component(c);
                for (auto c : ncomp) {
                    was.insert(c);
                }
                if (ncomp.size() > ret.size()) {
                    ret = ncomp;
                }
            }
        }
        return ret;
    }
};

void solveE () {
    int n;
    cin >> n;
    dsu d;
    vector<cell> res;
    while (res.size() < n) {
        d.random_next_cell();
        res = d.max_component();
    }
    cout << "! " << (res.front().color ? "B" : "W") << " ";
    for (auto [x, y, c] : res) {
        cout << x << " " << y << " ";
    }
    cout << endl;
}

int main(){
    ios::sync_with_stdio(false);
//    cin.tie(nullptr);

    int t;
    cin >> t;
    while(t--)
    solveE();


    cout.flush();
}
