#include <iostream>
#include <vector>
#include <algorithm>
#include <unordered_map>
#include <string>

using namespace std;
using ll = long long;

bool isSimilar(pair<string, string> a, pair<string, string> b) {
    if (a.first == b.first || a.second == b.second) return true;
    return false;
}

void solve() {
    ll n;
    string l, r;

    cin >> n;
    vector<pair<string, string>> data;
    unordered_map<string, int> left, right;

    while(n--) {
        cin >> l >> r;
        data.push_back(pair(l, r));
        if (left.find(l) != left.end()) {
            left[l]++;
        }
        else {
            left[l] = 1;
        }
        if (right.find(r) != right.end()) {
            right[r]++;
        }
        else {
            right[r] = 1;
        }
    }
    string pl {data[0].first}, pr{data[0].second};
    for (int i = 1; i < data.size(); ++i) {
        if (isSimilar(data[i], data[i - 1])) {
            left[pl]--;
            left[pr]--;
            pl = data[i].first;
            pr = data[i].second;
            continue;
        }        
        l = data[i].first;
        r = data[i].second;
        if (left[pl] > 1 || right[pr] > 1) {
            cout << "No\n";
            return;
        }

        pl = data[i].first;
        pr = data[i].second;
    }
    cout << "Yes\n";

}

int main() {
    
    ll t;
    cin >> t;
    while(t--) {
        solve();
    }
    return 0;
}