#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

using namespace std;

string multiply(string num1, string num2) {
    int n1 = num1.length();
    int n2 = num2.length();
    if (n1 == 0 || n2 == 0) return "0";
    if (num1 == "0" || num2 == "0") return "0";

    vector<int> result(n1 + n2, 0);

    for (int i = n1 - 1; i >= 0; i--) {
        int carry = 0;
        int d1 = num1[i] - '0';

        for (int j = n2 - 1; j >= 0; j--) {
            int d2 = num2[j] - '0';
            int sum = d1 * d2 + result[i + j + 1] + carry;
            carry = sum / 10;
            result[i + j + 1] = sum % 10;
        }
        result[i] += carry;
    }

    string s = "";
    int i = 0;
    while (i < result.size() && result[i] == 0) i++;

    while (i < result.size()) s += to_string(result[i++]);

    if (s.length() == 0) return "0";
    return s;
}

bool compare(string num1, string num2) {
    if (num1.length() != num2.length()) {
        return num1.length() < num2.length();
    }
    return num1 < num2;
}

bool isEqual(string num1, string num2) {
    return num1 == num2;
}

void solve() {
    string s;
    string c_str;
    cin >> s >> c_str;

    int n = s.length();
    int c_len = c_str.length();
    int c_val = stoi(c_str);

    for (int len_b = 1; len_b < n; ++len_b) {
        int len_a = n - len_b;

        string a_str = s.substr(0, len_a);
        string b_str = s.substr(len_a);

        if (a_str.length() > 1 && a_str[0] == '0') continue;
        if (b_str.length() > 1 && b_str[0] == '0') continue;

        string product = multiply(b_str, c_str);

        if (isEqual(product, a_str)) {
            cout << a_str << " " << b_str << endl;
            return;
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    solve();
    return 0;
}