from itertools import permutations
import sys

def solve():
	data = sys.stdin.read().strip().split()
	if not data:
		return
	it = iter(data)
	n = int(next(it))
	packing_boxes = []
	possible_dims = set()
	for _ in range(n):
		line = sys.stdin.readline().split()
		w = int(next(it))
		h = int(next(it))
		d = int(next(it))
		packing_boxes.append((w, h, d))
		possible_dims.update([w, h ,d])
	dims_list = list(possible_dims)
	max_volume = 0
	INF = 10**9

	for x in dims_list:
		for y in dims_list:
			min_global_z = INF
			for w, h, d in packing_boxes:
				max_z = 0
				if x <= w and y <= h:
					max_z = max(max_z, d)	
				if x <= w and y <= d:
					max_z = max(max_z, h)
				if y <= h and x <= w:
					max_z = max(max_z, d)
				if y <= h and x <= d:
					max_z = max(max_z, w)
				if x <= d and y <= w:
					max_z = max(max_z, h)
				if y <= d and x <= h:
					max_z = max(max_z, w)
				min_global_z = min(min_global_z, max_z)
				if min_global_z == 0:
					break
			volume = x * y * min_global_z
			if volume > max_volume:
				max_volume = volume
	print(max_volume)
solve()