#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <bitset>

#pragma GCC optimize("O3,unroll-loops")

using namespace std;

#ifdef Local
#define debug(...) cerr << #__VA_ARGS__ << " = " << __VA_ARGS__ << endl
#else
#define endl '\n'
#define debug(...) 1337
#endif

//#define int int64_t

using ll = long long;
using ld = long double;

//#define all(x) x.begin(), x.end()
#define sz(x) (int)x.size()

template <typename T, typename U>
bool smin(T& _a, U&& _b) {
    if (_a > _b) {
        _a = _b;
        return true;
    }
    return false;
}

template <typename T, typename U>
bool smax(T& _a, U&& _b) {
    if (_a < _b) {
        _a = _b;
        return true;
    }
    return false;
}

const int INF = 1e9 + 7;
const int mod = 1e9 + 7;
const char endc = '\n';
const int N = 1e6 + 100;

bitset<N + 10> dp;
bitset<N + 10> dp_ans;
bitset<N + 10> dp_async_case;


struct node {
    string type, s;
    int x;
};

void upd_dp(int x) {
    dp[0] = 1;
//    for (int i = N - 1; i >= x; --i) {
//        if (dp[i - x] == 1) dp[i] = 1;
//    }
    dp |= dp << x;
}

void upd_dp_async(int x) {
//    for (int i = 0; i < N; ++i) {
//        if (i + x > N) continue;
//        if (!dp[i]) continue;
//        dp_async_case[i + x] = 1;
//    }
    dp_async_case |= dp << x;
}

void case_start(int to_set) {
//    for (int i = 0; i < N; ++i) {
//        if (i + to_set > N) continue;
//        if (!dp[i]) continue;
//        dp_ans[i + to_set] = 1;
//    }
    dp_ans |= dp << to_set;
}


void case_async(int to_set) {
//    for (int i = 0; i < N; ++i) {
//        if (i + to_set > N) continue;
//        if (!dp_async_case[i]) continue;
//        dp_ans[i + to_set] = 1;
//    }
    dp_ans |= dp_async_case << to_set;
}

void solve() {
    int n;
    dp[0] = 1;
    dp_async_case[0] = 1;
    cin >> n;
    vector<node> all;
    vector<int> async_set, async_add;
    vector<node> all_no_delete;
    int fl = 0, id = -1;
    for (int i = 0; i < n; ++i) {
        string type, s;
        int x;
        cin >> type >> x >> s;
        node a;
        a.type = type;
        a.s = s;
        a.x = x;
        all_no_delete.push_back(a);
        if (a.s == "async") {
            if (a.type == "=") {
                async_set.push_back(x);
            } else {
                async_add.push_back(x);
            }
        }
        if (a.type == "=") {
            all.clear();
            fl = 1;
            id = i;
        }
        all.push_back(a);
    }

    if (fl == 0) {
        cout << 1 << endl;
        return;
    }

    vector<int> spec_async;
    for (int i = 0; i < id; ++i) {
        if (all_no_delete[i].type == "+" && all_no_delete[i].s == "async") {
            spec_async.push_back(all_no_delete[i].x);
            upd_dp(all_no_delete[i].x);
        }
    }

    if (all[0].s == "sync") {
        int must_add = 0;
        for (int i = 0; i < all.size(); ++i) {
            must_add += all[i].x;
        }
        case_start(must_add);
    }

    reverse(all.begin(), all.end());
    all.pop_back();
    reverse(all.begin(), all.end());

    vector<int> pref_sum(all.size() + 1);
    for (int i = 0; i < all.size(); ++i) {
        pref_sum[i + 1] = pref_sum[i] + all[i].x;
    }

    for (int i = 0; i <= all.size(); ++i) {
        int s = pref_sum[all.size()] - pref_sum[i];
        upd_dp_async(s);
        if (i < all.size() && all[i].s == "async") {
            upd_dp(all[i].x);
        }
    }


    for (auto c: async_set) {
        case_async(c);
    }

    int ans = 0;
    for (int i = 0; i <= N; ++i) {
        ans += dp_ans[i];
    }
//    for (auto c: dp_ans) ans += c;
    cout << ans << endl;
}

signed main() {
    ios::sync_with_stdio(false), cin.tie(nullptr);

    int tt = 1;
    //cin >> tt;
    while (tt--) {
        solve();
    }

    return 0;
}
