#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
#include <assert.h>

using namespace std;

#ifdef Local
#define debug(...) cerr << __LINE__ << " : " << #__VA_ARGS__ << " = " << __VA_ARGS__ << endl
#else
#define endl '\n'
#define debug(...) 1337
#endif

#define int int64_t

using ll = long long;
using ld = long double;

#define all(x) x.begin(), x.end()
#define sz(x) (int)x.size()

template <typename T, typename U>
bool smin(T& _a, U&& _b) {
    if (_a > _b) {
        _a = _b;
        return true;
    }
    return false;
}

template <typename T, typename U>
bool smax(T& _a, U&& _b) {
    if (_a < _b) {
        _a = _b;
        return true;
    }
    return false;
}

const char endc = '\n';

int dist(string& s, string& t) {
    int res = 0;
    for (int i = 0; i < sz(s); ++i) {
        res += s[i] != t[i];
    }
    return res;
}

void solve() {
    int a, b, c;
    cin >> a >> b >> c;
    string s(2000, 'a');
    string t = s, u = s;
    if (a > b + c) {
        cout << "No" << endl;
        return;
    }
    int x = max({a, b, c}), z = min({a, b, c}), y = a + b + c - x - z;
    for (int i = 0; i < z; ++i) {
        u[i] = 'b';
    }
    for (int i = 0; i < x; ++i) {
        if (i < x - y) {
            t[i] = 'b';
        } else {
            t[i] = 'c';
        }
    }
    cout << "Yes" << endl;
    vector<string> v = {s, t, u};
    sort(all(v));
    do {
        if (dist(v[0], v[1]) == a && dist(v[0], v[2]) == b && dist(v[1], v[2]) == c) {
            cout << v[0] << endl << v[1] << endl << v[2] << endl;
            return;
        }
    } while (next_permutation(all(v)));
    assert(false);
}

signed main() {
    ios::sync_with_stdio(false), cin.tie(nullptr);

    int tt = 1;
//    cin >> tt;
    while (tt--) {
        solve();
    }

    return 0;
}