﻿#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include <unordered_map>
#include <queue>
#include <iomanip>
#include <functional>
#include <numeric>
#include <cstring>
#include <math.h>
#include <string>
#include <deque>


using namespace std;

typedef long long ll;

int n;
void solve();

int main() {
	ios_base::sync_with_stdio(0);
	cin.tie(nullptr);

	int t = 1;
	cin >> t >> n;

	while (t--) {
		solve();
	}
}

void solve() {
	vector<vector<char>> a(4 * n, vector<char>(4 * n));
	vector<vector<int>> was(4 * n, vector<int>(4 * n));
	char resp;
	deque<pair<int, int>> q;
	int stx = 2 * n, sty = 2 * n;
	cout << "? " << stx << " " << sty << endl;
	cin >> a[stx][sty];

	function<void(int x, int y)> ans = [&](int x, int y) {
		was[x][y] = 2;
		cout << " " << x << " " << y;

		for (int i = -1; i < 2; ++i) {
			for (int j = -1; j < 2; ++j) {
				if (was[x + i][y + j] == 2 || a[x + i][y + j] != a[x][y]) continue;
				ans(x + i, y + j);
			}
		}
	};

	while (true) {
		pair<int, int> last{ stx, sty };
		int cur = 0;

		while (was[last.first][last.second] != 0) {
			++last.first;
		}

		q.push_back(last);
		was[last.first][last.second] = 1;

		while (!q.empty()) {
			auto fr = q.front();
			q.pop_back();

			for (int i = -1; i < 2; ++i) {
				for (int j = -1; j < 2; ++j) {
					if (was[fr.first + i][fr.second + j] == 0) {
						if (a[fr.first + i][fr.second + j] == 0) {
							cout << fr.first + i << " " << fr.second + j << endl;
							cin >> a[fr.first + i][fr.second + j];
						}

						if (a[fr.first + i][fr.second + j] == a[fr.first][fr.second]) {
							q.push_back({ fr.first + i, fr.second + j });
							was[fr.first + i][fr.second + j] = 1;
							++cur;

							if (cur == n) {
								cout << "! " << a[fr.first][fr.second];
								ans(fr.first, fr.second);
								cout << endl;
								return;
							}
						}
					}
				}
			}

			last = fr;
		}
	}
}