#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;

const int kMaxN = 10;
const int kMaxM = kMaxN * 6;
int cells[kMaxN][kMaxM];
bool used[kMaxN][kMaxM];

std::vector<std::pair<int, int> > deltas = {{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}};

int dfs(int x, int y, int type) {
    used[x][y] = true;
    int ans = 1;
    for (auto [dx, dy] : deltas) {
        int nx = x + dx;
        int ny = y + dy;
        if (0 <= nx && nx <= kMaxN && 0 <= ny && ny <= kMaxM) {
            if (cells[nx][ny] == type && !used[nx][nx]) {
                ans += dfs(nx, ny, type);
            }
        }
    }
    return ans;
}

void print_dfs(int x, int y, int type, int &left) {
    used[x][y] = true;
    if (left == 0) {
        return;
    }
    std::cout << x << " " << y << " ";
    left -= 1;
    for (auto [dx, dy] : deltas) {
        int nx = x + dx;
        int ny = y + dy;
        if (0 <= nx && nx <= kMaxN && 0 <= ny && ny <= kMaxM) {
            if (cells[nx][ny] == type && !used[nx][nx]) {
                print_dfs(nx, ny, type, left);
            }
        }
    }
}

void solve(){
    int t, n;
    std::cin >> t >> n;
    srand(time(0));
    for (int i = 0; i < t; ++i) {
        int x_start = rand();
        int y_start = rand();
        for (int dx = 0; dx < kMaxN; ++dx) {
            for (int dy = 0; dy < kMaxM; ++dy) {
                std::cout << "! " << x_start + dx << " " << y_start + dy << std::endl;
                char c;
                std::cin >> c;
                cells[dx][dy] = (c == 'W') ? 0 : 1;
            }
        }
        int mx = 0;
        for (int dx = 0; dx < kMaxN; ++dx) {
            for (int dy = 0; dy < kMaxM; ++dy) {
                if (used[dx][dy]) {
                    continue;
                }
                mx = dfs(dx, dy, cells[dx][dy]);
                if (mx >= n) {
                    std::cout << "! " << ((cells[dx][dy] == 0) ? "W" : "B") << " ";
                    int left = n;
                    for (int i = 0; i < kMaxN; ++i) {
                        for (int j = 0; j < kMaxM; ++j) {
                            used[i][j] = false;
                        }
                    }
                    print_dfs(dx, dy, cells[dx][dy], left);
                    std::cout << std::endl;
                    break;
                }
            }
            if (mx >= n) {
                break;
            }
        }
        if (mx < n) {
            std::cout << "ERROR: mx = " << mx << "\n";
            return;
        }
    }
}

signed main(){
    //freopen("input.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    int t = 1;
    //cin >> t;
    while(t--){
        solve();
    }
    return 0;
}
