#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;

std::vector<std::pair<int, int> > deltas = {{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}};

std::vector<std::pair<int, int> > get_adj(int x, int y) {
    std::vector<std::pair<int, int> > ans;
    for (auto [dx, dy] : deltas) {
        ans.push_back({x + dx, y + dy});
    }
    return ans;
}

void solve(){
    int t, n;
    std::cin >> t >> n;
    srand(time(0));
    for (int i = 0; i < t; ++i) {
        int x_start = rand() % 100000000 + 228;
        int y_start = rand() % 100000000 + 1337;

        std::cout << "? " << x_start << " " << y_start << std::endl;
        char type;
        std::cin >> type;

        std::vector<std::pair<int, int> > ans = {{x_start, y_start}};

        std::set<std::pair<int, int> > avail;
        for (auto p : get_adj(x_start, y_start)) {
            avail.insert(p);
        }

        std::set<std::pair<int, int> > used = {{x_start, y_start}};
        while(ans.size() != n) {
            if (avail.size() == 0) {
                return;
            }
            std::pair<int, int> ch = *avail.begin();
            avail.erase(ch);
            used.insert(ch);
            std::cout << "? " << ch.first << " " << ch.second << std::endl;
            char cur_type;
            std::cin >> cur_type;
            if (cur_type == type) {
                ans.push_back(ch);
                for (auto p : get_adj(ch.first, ch.second)) {
                    if (used.count(p) == 0) {
                        avail.insert(p);
                    }
                }
            }
        }
        std::cout << "! " << type << " ";
        for (auto el : ans) {
            std::cout << el.first << " " << el.second << " ";
        }
        std::cout << std::endl;
    }
}

signed main(){
    //freopen("input.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    int t = 1;
    //cin >> t;
    while(t--){
        solve();
    }
    return 0;
}
