﻿//﻿#define _CRT_SECURE_NO_WARNINGS
#include <algorithm>
#include <cmath>
#include <cstdio>
#include <deque>
#include <fstream>
#include <iomanip>
#include <numeric>
#include <iostream>
#include <map>
#include <queue>
#include <random>
#include <set>
#include <stack>
#include <string>
#include <tuple>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <cstring>
#define int long long
#define double long double
#define fr(a, n) for(int i = a; i < n; i++)
#define frr(a, n) for(int j = a; j < n; j++)
#define frrr(a, n) for(int k = a; k < n; k++)
#define frd(a, n) for(int i = a; i > n; i--)
#define frdd(a, n) for(int j = a; j > n; j--)
#define frddd(a, n) for(int k = a; k > n; k--)
#define all(h) h.begin(), h.end()
#define rall(h) h.rbegin(), h.rend()
#define pii pair<int, int>
#define tii tuple<int, int, int>
#pragma GCC target("avx2")
#pragma GCC optimize("O3")
#pragma GCC optimize("unroll-loops")
#pragma comment(linker, "/STACK:46777216")

using namespace std;
mt19937 rng(228);
mt19937_64 rng_64(228);

map <pair <int, int>, char> know;
pair <char, bool> getcolor(int x, int y) {
    if (know.find({ x, y }) != know.end()) {
        return { know[{x, y}], false };
    }
    else {
        cout << "? " << x << ' ' << y << endl;
        char res;
        cin >> res;
        know[{x, y}] = res;
        return { res, true };
    }
}

int n;

struct DSU {
    map <pair <int, int>, int> mp;
    vector < pair <int, int>> rmp;
    vector <int> par, sz;
    vector <vector <int>> ch;
    DSU() {}
    void add(int x, int y) {
        mp[{x, y}] = par.size();
        par.push_back(par.size());
        sz.push_back(1);
        rmp.emplace_back(x, y);
        ch.emplace_back();
    }
    int color(int x) {
        if (par[x] == x) return x;
        return par[x] = color(par[x]);
    }
    int color(int x, int y) {
        int res = mp[{x, y}];
        if (par[res] == res) return res;
        return par[res] = color(par[res]);
    }
    void unite(int x1, int y1, int x2, int y2) {
        int c1 = color(x1, y1);
        int c2 = color(x2, y2);
        if (c1 != c2) {
            if (sz[c1] < sz[c2]) {
                swap(c1, c2);
            }
            sz[c1] += sz[c2];
            par[c2] = c1;
            ch[c1].push_back(c2);
        }
    }
    int getsz(int x, int y) {
        int c = color(x, y);
        return sz[c];
    }
    void out(int x, int y) {
        int c = color(x, y);
        vector <int> st = { c };
        int vis = 0;
        while (vis < n) {
            int cur = st.back();
            st.pop_back();
            cout << rmp[cur].first << ' ' << rmp[cur].second << ' ';
            ++vis;
            if (vis == n) return;
            for (int i : ch[cur]) {
                st.push_back(i);
            }
        }
    }
};

const vector <pair <int, int>> offs = { {-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1} };

void solve() {
    know.clear();
    priority_queue <pair <int, pair <int, int>>> pq;
    DSU dsu;
    pq.push({ 1, {0, 0} });
    dsu.add(0, 0);
    while (true) {
        auto curr = pq.top();
        int x = curr.second.first;
        int y = curr.second.second;
        pq.pop();
        auto c = getcolor(x, y);
        vector <pair <int, int>> tpsh;
        for (const auto& off : offs) {
            int nx = x + off.first;
            int ny = y + off.second;
            auto nc = getcolor(nx, ny);
            if (nc.second) {
                dsu.add(nx, ny);
                if (nc.first == c.first) {
                    dsu.unite(x, y, nx, ny);
                }
                tpsh.push_back({ nx, ny });
            }
            else {
                if (nc.first == c.first) {
                    dsu.unite(x, y, nx, ny);
                }
            }
        }
        if (dsu.getsz(x, y) >= n) {
            cout << "! " << c.first << ' ';
            dsu.out(x, y);
            cout << endl;
            return;
        }
        for (const auto& i : tpsh) {
            pq.push({ dsu.getsz(i.first, i.second), i });
        }
    }
}

int32_t main() {
    //ios_base::sync_with_stdio(false); cin.tie(nullptr); cout.tie(nullptr);
    int t;
    cin >> t >> n;
    while (t--) {
        solve();
    }
    return 0;
}