﻿using System;
using System.Linq;
using System.Numerics;
using System.Drawing;
using System.Collections;
using System.Collections.Generic;

namespace Olymp
{
    class Program
    {
        static void Main(string[] args)
        {
            uint num = (uint)GetOne();
            var bytes = BitConverter.GetBytes(num);
            BitArray arr = new BitArray(bytes);

            Stack<int> results = new Stack<int>();

            for (int i = 0; i < arr.Length;)
            {
                int part = 0;
                if (results.Count > 0)
                    part = 0b1000_0000;
                for (int j = 0; j < 7; j++, i++)
                {
                    if (i >= arr.Length) break;
                    if (arr[i])
                        part |= 1 << j;
                }
                results.Push(part);
            }

            while (results.Peek() == 128)
                results.Pop();

            Console.WriteLine(string.Join(" ", results));
        }

        #region InputHelpers
        static string Input() => Console.ReadLine();
        static long GetOne() => long.Parse(Console.ReadLine());
        static (long, long) GetTwo()
        {
            string[] parts = Console.ReadLine().Split();
            return (long.Parse(parts[0]), long.Parse(parts[1]));
        }
        static (long, long, long) GetThree()
        {
            string[] parts = Console.ReadLine().Split();
            return (long.Parse(parts[0]), long.Parse(parts[1]), long.Parse(parts[2]));
        }
        static long[] GetN() => Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
        static T Print<T>(T arg)
        {
            Console.WriteLine(arg);
            return arg;
        }
        #endregion
    }
}
