#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using vll = vector<ll>;
using vi = vector<int>;

#define all(x) (x).begin(), (x).end()
#define fast ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);


ll prefSum(vector<ll> &pf, int l, int r){
    if (l == 0){
        return pf[r];
    }
    return pf[r] - pf[l - 1];
}

vector<ll> prefArr(vector<int> &a){
    int n = a.size();
    vector<ll> res(n, 0);
    res[0] = a[0];
    for (int i = 1; i < n; i++){
        res[i] = a[i] + res[i - 1];
    }
    return res;
}

const ll mod = 2 * 1e18 + 1;
ll binpow(ll a, ll b, ll mod) {
    ll res = 1;
    while (b > 0) {
        if (b&1) {
            res = res * a % mod;
        }
        a = a * a % mod;
        b >>= 1;
    }
    return res;
}

struct segtree {
    int n;
    vector<ll> t, lazy;
    segtree(int n_): n(n_), t(4*n_), lazy(4*n_) {}
    void build(vector<long long>& a, int v, int tl, int tr){
        if (tl == tr) t[v] = a[tl];
        else{
            int tm = (tl + tr) / 2;
            build(a, v*2, tl, tm);
            build(a, v*2+1, tm+1, tr);
            t[v] = t[v*2] + t[v*2 + 1];
        }
    }
    void push(int v, int tl, int tr){
        if (lazy[v] != 0){
            t[v] += (tr - tl + 1) * lazy[v];
            if (tl != tr){
                lazy[v*2] += lazy[v];
                lazy[v*2+1] += lazy[v];
            }
            lazy[v] = 0;
        }
    }
    void update(int v, int tl, int tr, int l, int r, long long add){
        push(v, tl, tr);
        if (l > r) return;
        if (l == tl && r == tr){
            lazy[v] += add;
            push(v, tl, tr);
            return;
        }
        int tm = (tl + tr) / 2;
        update(v * 2, tl, tm, l, min(r, tm), add);
        update(v*2+1, tm+1, tr, max(l, tm+1), r, add);
        t[v] = t[v*2] + t[v*2+1];
    }
    long long sum(int v, int tl, int tr, int l, int r){
        push(v, tl, tr);
        if (l > r) return 0;
        if (l == tl && r == tr)
            return t[v];
        int tm = (tl + tr) / 2;
        return sum(v*2, tl, tm, l, min(r, tm)) + sum(v*2+1, tm+1, tr, max(l, tm+1), r);
    }
    void update(int l, int r, long long add){
        update(1, 0, n - 1, l, r, add);
    }
    long long sum(int l, int r){
        return sum(1, 0, n - 1, l, r);
    }

};

struct DSU {
    vi p, sz;
    DSU(int n): p(n), sz(n,1) {
        iota(all(p), 0);
    }
    int find(int x) {
        return p[x] == x ? x : p[x] = find(p[x]);
    }
    bool unite(int a, int b) {
        a = find(a); b = find(b);
        if (a == b) return false;
        if (sz[a] < sz[b]) {
            swap(a, b);
        }
        p[b] = a;
        sz[a] += sz[b];
        return true;
    }
};

bool check(int x){

}


int binarySearch(int l, int r){
    int res = r + 1;
    while(l <= r){
        int m = l + (r - l) / 2;
        if (check(m)){
            res = m;
            r = m - 1;
        } else{
            l = m + 1;
        }
    }
    return res;
}

vector<pair<string, string>> v;
map<string, int> w1;
map<string, int> w2;
void solve(){
    int n;
    cin >> n;
    w1.clear();
    w2.clear();
    v.clear();
    v.resize(n);
    for (int i = 0; i < n; i++){
        string s1, s2;
        cin >> s1 >> s2;
        v[i] = {s1, s2};
        w1[s1]++;
        w2[s2]++;
    }
    bool vivod = false;
    w1[v[0].first]--; w2[v[0].second]--;
    for(int i = 1; i < n; i++){
        w1[v[i].first]--; w2[v[i].second]--;
        if (v[i].first != v[i - 1].first && v[i].second != v[i - 1].second && (w1[v[i - 1].first] > 0 || w2[v[i - 1].second] > 0)){
            cout << "No\n";
            vivod = true;
            break;
        }
    }
    if(!vivod) cout << "Yes\n";
}



int main() {
    fast;

    int t;
    cin >> t;
    while(t--){
        solve();
    }

}
