from collections import deque
import sys


def main():
    data = sys.stdin.read().splitlines()
    if not data:
        return

    n = int(data[0].strip())
    index = 1
    initial_songs = []
    for i in range(n):
        parts = data[index].split()
        index += 1
        name = parts[0]
        length = int(parts[1])
        initial_songs.append((name, length))

    m = int(data[index].strip())
    index += 1
    events = []
    for i in range(m):
        parts = data[index].split()
        index += 1
        t = int(parts[0])
        name = parts[1]
        length = int(parts[2])
        events.append((t, name, length))

    queue = deque(initial_songs)
    event_index = 0
    current_time = 0
    results = []

    while queue or event_index < len(events):
        if queue:
            name, length = queue.popleft()
            start_time = current_time
            results.append((name, start_time))
            end_time = start_time + length
            events_to_add = []
            while event_index < len(events) and events[event_index][0] <= end_time:
                t, name_event, len_event = events[event_index]
                events_to_add.append((name_event, len_event))
                event_index += 1
            queue.extendleft(events_to_add)
            current_time = end_time
        else:
            next_t = events[event_index][0]
            events_to_add = []
            while event_index < len(events) and events[event_index][0] == next_t:
                t, name_event, len_event = events[event_index]
                events_to_add.append((name_event, len_event))
                event_index += 1
            queue.extendleft(events_to_add)
            current_time = next_t

    for name, start in results:
        print(f"{name} {start}")


if __name__ == "__main__":
    main()