#include <bits/stdc++.h>
using namespace std;

inline int popcount_u32(uint32_t x) {
#ifdef _MSC_VER
    return __popcnt(x);
#else
    return __builtin_popcount(x);
#endif
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;
    while (t--) {
        int n;
        cin >> n;

        unordered_map<uint32_t, int> cnt;
        cnt.reserve(n * 2);
        cnt.max_load_factor(0.7f);

        for (int i = 0; i < n; ++i) {
            uint32_t x;
            cin >> x;
            cnt[x] ^= 1; // только чётность
        }

        int best_pop = 40;
        uint32_t ans = 0;
        bool found = false;

        for (auto &p : cnt) {
            if (p.second == 1) { // нечётная частота
                int pc = popcount_u32(p.first);
                if (pc < best_pop) {
                    best_pop = pc;
                    ans = p.first;
                    found = true;
                }
            }
        }

        if (!found) cout << -1 << "\n";
        else cout << ans << "\n";
    }

    return 0;
}