from collections import deque

n = int(input())
queue = deque()
for _ in range(n):
    name, length = input().split()
    length = int(length)
    queue.append((name, length))

m = int(input())
events = []
for _ in range(m):
    t, name, length = input().split()
    t = int(t)
    length = int(length)
    events.append((t, name, length))

current_time = 0
event_index = 0
playlist = []

while queue or event_index < m:
    if queue:
        name, length = queue.popleft()
        start_time = current_time
        playlist.append((name, start_time))
        end_time = current_time + length


        while event_index < m and events[event_index][0] <= end_time:
            t, ename, elen = events[event_index]
            queue.appendleft((ename, elen))
            event_index += 1

        current_time = end_time
    else:

        t, ename, elen = events[event_index]
        current_time = t
        queue.appendleft((ename, elen))
        event_index += 1

for name, start in playlist:
    print(name, start)
