from collections import deque
import sys
input = sys.stdin.readline

n = int(input())
queue = deque()
for _ in range(n):
    name, length = input().split()
    length = int(length)
    queue.append((name, length))

m = int(input())
events = []
for _ in range(m):
    t_add, name, length = input().split()
    t_add = int(t_add)
    length = int(length)
    events.append((t_add, name, length))

current_time = 0
event_index = 0
playlist = []

while queue or event_index < m:
    if queue:
        name, length = queue.popleft()
        start_time = current_time
        playlist.append((name, start_time))
        end_time = current_time + length


        while event_index < m and events[event_index][0] <= end_time:
            t_add, ename, elen = events[event_index]
            queue.appendleft((ename, elen))
            event_index += 1

        current_time = end_time
    else:

        t_add, ename, elen = events[event_index]
        current_time = t_add
        queue.appendleft((ename, elen))
        event_index += 1

for name, start in playlist:
    print(name, start)
