#include <bits/stdc++.h>

using namespace std;
using ll = long long;
#define int ll
const int INF = 1e18;

struct Node{
    int left, right;
    int pref_inc, pref_dec;
    int suff_inc, suff_dec;
    int pref_good, suff_good;
    int ans;
    int len;
    Node(){}
    Node(int x){
        left = right = x;
        pref_dec = pref_inc = suff_dec = suff_inc = ans = len = 1;
        pref_good = suff_good = 0;
    }
};

Node merge(Node a, Node b){
    Node res;
    res.left = a.left;
    res.right = b.right;
    res.pref_inc = a.pref_inc;
    res.pref_dec = a.pref_dec;
    res.suff_inc = b.suff_inc;
    res.suff_dec = b.suff_dec;
    res.ans = max(a.ans, b.ans);
    res.len = a.len + b.len;
    res.pref_good = a.pref_good;
    res.suff_good = b.suff_good;
    if(a.right == b.left + 1){
        if(a.pref_good + a.pref_inc == a.len){
            res.pref_good = a.pref_good + b.pref_dec;
        }
        if(b.len == b.suff_dec){
            res.suff_dec = a.suff_dec + b.len;
            res.suff_good = a.suff_good;
        }
        if(a.len == a.pref_dec){
            res.pref_dec = a.len + b.pref_dec;
        }
        res.pref_good = max(res.pref_good, b.pref_dec);
        res.ans = max(res.ans, 2 * min(a.suff_good, a.suff_dec + b.pref_dec) + 1);
        
    } else if(a.right + 1 == b.left){
        if(b.suff_good + b.suff_dec == b.len){
            res.suff_good = b.suff_good + a.suff_inc;
        }
        if(b.len == b.suff_inc){
            res.suff_inc = a.suff_inc + b.len;
            
        }
        if(a.len == a.pref_inc){
            res.pref_inc = a.len + b.pref_inc;
            res.pref_good = b.pref_good;
        }
        res.suff_good = max(res.suff_good, a.suff_inc);
        res.ans = max(res.ans, 2 * min(b.pref_good, a.suff_inc + b.pref_inc) + 1);

    }
    // cout << "a\n";
    return res; 
}

struct SegTree{
    int n;
    vector<Node> t;
    SegTree(const vector<int> &a){
        n = a.size();
        t.resize(4 * n);
        build(a, 0, 0, n);
    }
    void build(const vector<int> &a, int v, int l, int r){
        if(r - l == 1){
            t[v] = a[l];
            return;
        }
        int mid = (l + r) / 2;
        build(a, v * 2 + 1, l, mid);
        build(a, v * 2 + 2, mid, r);
        t[v] = merge(t[v * 2 + 1], t[v * 2 + 2]);
    }

    void update(int v, int l, int r, int i, int x){
        if(r - l == 1){
            t[v] = x;
            return;
        }
        int mid = (l + r) / 2;
        if(i < mid){
            update(v * 2 + 1, l, mid, i, x);
        } else {
            update(v * 2 + 2, mid, r, i, x);
        }
        t[v] = merge(t[v * 2 + 1], t[v * 2 + 2]);
    }

    void update(int i, int x){
        update(0, 0, n, i, x);
    }

    int get(){
        return t[0].ans;
    }
};

void solve(){
    int n;
    cin >> n;
    vector<int> a(n);
    for(auto &x : a){
        cin >> x;
    }
    SegTree st(a);
    cout << st.get() << '\n';
    int q;
    cin >> q;
    while(q--){
        int i, x;
        cin >> i >> x;
        i--;
        st.update(i, x);
        cout << st.get() << '\n';
    }
}

signed main(){
    #ifdef MYDEBUG
    freopen("input.txt", "r", stdin);
    #endif
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int t = 1;
    // cin >> t;
    while(t--){
        solve();
    }
}