import sys
import math
import bisect

input = sys.stdin.readline
MOD = 998244353

n = int(input().strip())
a = list(map(int, input().split()))

# pref[i] = gcd of a[0..i-1] (we need pref indices 0..n-1 corresponding to s-1)
pref = [0] * (n + 1)
for i in range(1, n + 1):
    pref[i] = math.gcd(pref[i - 1], a[i - 1])
# pref_idx array that we will make runs from: values for indices 0..n-1 correspond to pref[0..n-1]
pref_vals = pref[:n]  # length n, pref_vals[k] = gcd(a1..a_k) with pref_vals[0] = pref[0] = 0

# build runs of equal pref_vals: list of (value, l_index, r_index) on indices 0..n-1
runs = []
if n > 0:
    cur_val = pref_vals[0]
    l = 0
    for idx in range(1, n):
        if pref_vals[idx] == cur_val:
            continue
        else:
            runs.append((cur_val, l, idx - 1))
            cur_val = pref_vals[idx]
            l = idx
    runs.append((cur_val, l, n - 1))
else:
    runs = []

# For binary search: array of run start indices
run_starts = [r[1] for r in runs]  # l indices

# suff array: gcd of a[j+1..n], we need suff[j+1] for j from 1..n
suff = [0] * (n + 2)
for i in range(n, 0, -1):
    suff[i] = math.gcd(suff[i + 1], a[i - 1])

ans = 0

# prev list of (lcm_value, cnt) for subarrays ending at j-1
prev = []  # initially empty

for j in range(1, n + 1):
    x = a[j - 1]
    # build current list for subarrays ending at j
    cur = [(x, 1)]
    for (val, cnt) in prev:
        # extend previous lcm with x
        g = math.gcd(val, x)
        nl = val // g * x
        if cur and cur[-1][0] == nl:
            # merge counts
            cur[-1] = (cur[-1][0], cur[-1][1] + cnt)
        else:
            cur.append((nl, cnt))

    # Now cur is list of (lcm_value, cnt), ordered from starts nearest to j to farthest.
    # We will walk cur and for each compute sum over its block of starts s: S..E
    cumulative = 0  # number of starts already processed (from right)
    right_suff = suff[j + 1] if j < n else 0

    for (lcm_val, cnt) in cur:
        S = j - cumulative - cnt + 1
        E = j - cumulative
        # corresponding pref indices are pL = S-1, pR = E-1  (they lie in 0..n-1)
        pL = S - 1
        pR = E - 1
        if pL < 0:
            pL = 0
        if pR < 0:
            pR = -1  # empty
        if pL <= pR:
            T = math.gcd(lcm_val, right_suff)
            # sum over pref indices p in [pL..pR] of gcd(T, pref_vals[p])
            # find first run that may overlap pL using bisect on run_starts
            idx = bisect.bisect_right(run_starts, pL) - 1
            if idx < 0:
                idx = 0
            # move left if needed until runs[idx].r >= pL or idx out of range
            while idx < len(runs) and runs[idx][2] < pL:
                idx += 1
            ssum = 0
            k = idx
            while k < len(runs) and runs[k][1] <= pR:
                val_run, lrun, rrun = runs[k]
                ol = max(lrun, pL)
                orr = min(rrun, pR)
                if ol <= orr:
                    length = orr - ol + 1
                    ssum += length * math.gcd(T, val_run)
                k += 1
            ans = (ans + ssum) % MOD

        cumulative += cnt

    prev = cur

print(ans % MOD)
