from collections import deque

n = int(input())
queue = deque()
for _ in range(n):
    parts = list(map(str, input().split()))
    name = parts[0]
    length = int(parts[1])
    queue.append((name, length))

m = int(input())
events = []
for _ in range(m):
    parts = list(map(str, input().split()))
    t = int(parts[0])
    name = parts[1]
    length = int(parts[2])
    events.append((t, name, length))

current_time = 0
event_index = 0
output = []

while queue or event_index < len(events):
    if queue:
        name, length = queue.popleft()
        start_time = current_time
        output.append((name, start_time))
        end_time = current_time + length


        new_events = []
        while event_index < len(events) and events[event_index][0] <= end_time:
            t, e_name, e_len = events[event_index]
            new_events.append((e_name, e_len))
            event_index += 1

        for e_name, e_len in new_events:
            queue.appendleft((e_name, e_len))

        current_time = end_time
    else:
        t, e_name, e_len = events[event_index]
        current_time = t
        queue.append((e_name, e_len))
        event_index += 1

for name, start_time in output:
    print(name, start_time)


