def solve():
    try:
        n_str = input()
        if not n_str:
            return False
        
        n = int(n_str)
        
        a = list(map(int, input().split()))
        
        q = int(input())

        queries = []
        for _ in range(q):
            i, x = map(int, input().split())
            queries.append((i - 1, x))

    except EOFError:
        return False
    except Exception as e:
        return False

    def get_max_palindrome(current_a, n):
        if n == 0:
            return 0
        
        L = [current_a[i] - i for i in range(n)]
        R = [current_a[i] + i for i in range(n)]

        LL = [1] * n
        RL = [1] * n
        
        for i in range(1, n):
            if L[i] == L[i-1]:
                LL[i] = LL[i-1] + 1
        
        for i in range(n - 2, -1, -1):
            if R[i] == R[i+1]:
                RL[i] = RL[i+1] + 1
        
        max_len = 1
        
        for i in range(n):
            odd_len = 2 * min(LL[i], RL[i]) - 1
            max_len = max(max_len, odd_len)
            
            if i + 1 < n and current_a[i] == current_a[i+1]:
                even_len = 2 * min(LL[i], RL[i+1])
                max_len = max(max_len, even_len)
                
        return max_len

    results = []
    initial_max_len = get_max_palindrome(a, n)
    results.append(initial_max_len)
    
    for i, x in queries:
        a[i] = x
        current_max_len = get_max_palindrome(a, n)
        results.append(current_max_len)

    for res in results:
        print(res)
    
    return True

if __name__ == "__main__":
    solve()
