#include <bits/stdc++.h>
#include <math.h>
using namespace std;

#define int long long
#define double long double

double f(double x, double y) {
    return (sin(x) + sin(y) - sin(x+y));
}

double lerp(double x1, double x2, double k) {
    return (x1 * (1-k) + x2 * k);
}

double binsearch_between(double x1, double x2, double y1, double y2, function<double(double,double)> greater) {
    int depth = 20;
    double l = 1e-12, r = 1 - 1e-12;
    double mid;
    while (depth--) {
        mid = (l+r) * .5;

        double midr = mid + 1e-12;
        double midl = mid - 1e-12;

        double mid_v = f(
            lerp(x1, x2, mid),
            lerp(y1, y2, mid)
        );
        double midlv = f(
            lerp(x1, x2, midl),
            lerp(y1, y2, midl)
        );
        double midrv = f(
            lerp(x1, x2, midr),
            lerp(y1, y2, midr)
        );

        if (greater(mid_v, midlv) && greater(mid_v, midrv)) {
            break;
        } else if (greater(mid_v, midrv)) {
            r = mid;
        } else {
            l = mid;
        }
    }


    double midv = f(
        lerp(x1, x2, mid),
        lerp(y1, y2, mid)
    );

    double lv = f(
        x1, y1
    );

    double rv = f(
        x2, y2
    );

    if (greater(rv, lv) && greater(rv, midv)) {
        return 1;
    }
    if (greater(lv, rv) && greater(lv, midv)) {
        return 0;
    }
    return mid;
}

tuple<double, double, double> bs(double x1, double x2, double y1, double y2) {
    double mxans = binsearch_between(x1, x2, y1, y2, 
        [](double a, double b){return a > b;});
    double mnans(binsearch_between(x1, x2, y1, y2, 
        [](double a, double b){return a < b;}));
    double x = lerp(x1, x2, mxans);
    double y = lerp(y1, y2, mxans);
    double x_= lerp(x1, x2, mnans);
    double y_= lerp(y1, y2, mnans);
    double val = abs(f(x, y));
    double val_ = abs(f(x_, y_));

    // cout << "BTW: " << x1 << ' ' << y1 << ',' << x2 << ' ' << y2 << '\n';
    // cout << "AAA: " << x << ' ' << y << ' ' << val << " : " << x_ << ' ' << y_ << ' ' << val_ << '\n';

    return max(make_tuple(val, x, y), make_tuple(val_, x_, y_));
}

double solve(double rx1, double ry1, double rx2, double ry2) {
    const double twopi = acos((double)0) * 4;
    // const double step = twopi/200;

    cout << fixed << setprecision(12);

    const double x1 = twopi/3.;
    const double y1 = twopi/3.;
    const double x2 = twopi*2/3.;
    const double y2 = twopi*2/3.;

    if (rx2 < rx1) swap(rx2, rx1);
    if (ry2 < ry1) swap(ry2, ry1);

    if (
        (rx1 < x1 && x1 < rx2 && ry1 < y1 && y1 < ry2) || 
        (rx1 < x2 && x2 < rx2 && ry1 < y2 && y2 < ry2)
    ) {
        return abs(f(x1, y1));
    }

    vector<tuple<double, double, double>> variants = { 
        bs(rx1, rx2, ry1, ry1),
        bs(rx1, rx2, ry2, ry2),
        bs(rx1, rx1, ry1, ry2),
        bs(rx2, rx2, ry1, ry2)
     };
    sort(variants.begin(), variants.end());

    // cout << f(6, 6) << " " << f(6, 6.25) << " " << f(6.25, 6) << " " << f(6.25, 6.25) << "<--- \n";

    // cout << get<0>(variants[3]) << ' ';
    // cout << get<1>(variants[3]) << ' ';
    // cout << get<2>(variants[3]) << ' ';
    return get<0>(variants[3]);

    // return max(
    //     max(
    //         binsearch_between(rx1, rx2, ry1, ry1),
    //         binsearch_between(rx1, rx2, ry2, ry2)
    //     ), 
    //     max(
    //         binsearch_between(rx1, rx1, ry1, ry2),
    //         binsearch_between(rx2, rx2, ry1, ry2)
    //     )
    // );

    



    // for (double i = 0; i < twopi + DBL_EPSILON; i+=step) {
    //     for (double j = 0; j < twopi + DBL_EPSILON; j+=step) {
    //         double val = abs(sin(i)+sin(j)-sin(i+j));
    //         string lumin = " .,-+*ag%&@";
    //         char c = lumin[(int)(val * 3.4)];
    //         cout << c;
    //     }
    //     cout << '\n';
    // }
}


signed main() {
    // double x1, x2, y1, y2;
    // cin >> x1 >> y1 >> x2 >> y2;

    double a1, a2, b1, b2, c1, c2, r;
    cin >> r;
    cin >> a1 >> a2 >> b1 >> b2 >> c1 >> c2;
    

    double x1 = b1-a2;
    double x2 = b2-a1;
    double y1 = c1-b2;
    double y2 = c2-b1;

    // cout << "AAAAB: " << x1 << ' ' << y1 << ',' << x2 << ' ' << y2 << '\n';


    cout << 
    (r*r*0.5) * 
    solve(x1, y1, x2, y2);
}